/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class SpinAttackEffectLayer<T extends LivingEntity>
extends LayerRenderer<T, PlayerModel<T>> {
    public static final ResourceLocation field_204836_a = new ResourceLocation("textures/entity/trident_riptide.png");
    private final ModelRenderer field_229143_b_ = new ModelRenderer(64, 64, 0, 0);

    public SpinAttackEffectLayer(IEntityRenderer<T, PlayerModel<T>> p_i50920_1_) {
        super(p_i50920_1_);
        this.field_229143_b_.addBox(-8.0f, -16.0f, -8.0f, 16.0f, 32.0f, 16.0f);
    }

    @Override
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((LivingEntity)entitylivingbaseIn).isSpinAttacking()) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.getEntityCutoutNoCull(field_204836_a));
            for (int i = 0; i < 3; ++i) {
                matrixStackIn.push();
                float f = ageInTicks * (float)(-(45 + i * 5));
                matrixStackIn.rotate(Vector3f.YP.rotationDegrees(f));
                float f1 = 0.75f * (float)i;
                matrixStackIn.scale(f1, f1, f1);
                matrixStackIn.translate(0.0, -0.2f + 0.6f * (float)i, 0.0);
                this.field_229143_b_.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
                matrixStackIn.pop();
            }
        }
    }
}

