/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.debug.BeeDebugRenderer;
import net.minecraft.client.renderer.debug.CaveDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkBorderDebugRenderer;
import net.minecraft.client.renderer.debug.ChunkInfoDebugRenderer;
import net.minecraft.client.renderer.debug.CollisionBoxDebugRenderer;
import net.minecraft.client.renderer.debug.EntityAIDebugRenderer;
import net.minecraft.client.renderer.debug.GameTestDebugRenderer;
import net.minecraft.client.renderer.debug.HeightMapDebugRenderer;
import net.minecraft.client.renderer.debug.LightDebugRenderer;
import net.minecraft.client.renderer.debug.NeighborsUpdateDebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingDebugRenderer;
import net.minecraft.client.renderer.debug.PointOfInterestDebugRenderer;
import net.minecraft.client.renderer.debug.RaidDebugRenderer;
import net.minecraft.client.renderer.debug.SolidFaceDebugRenderer;
import net.minecraft.client.renderer.debug.StructureDebugRenderer;
import net.minecraft.client.renderer.debug.VillageSectionsDebugRender;
import net.minecraft.client.renderer.debug.WaterDebugRenderer;
import net.minecraft.client.renderer.debug.WorldGenAttemptsDebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;

public class DebugRenderer {
    public final PathfindingDebugRenderer pathfinding = new PathfindingDebugRenderer();
    public final IDebugRenderer water;
    public final IDebugRenderer chunkBorder;
    public final IDebugRenderer heightMap;
    public final IDebugRenderer collisionBox;
    public final IDebugRenderer neighborsUpdate;
    public final CaveDebugRenderer cave;
    public final StructureDebugRenderer structure;
    public final IDebugRenderer light;
    public final IDebugRenderer worldGenAttempts;
    public final IDebugRenderer solidFace;
    public final IDebugRenderer field_217740_l;
    public final PointOfInterestDebugRenderer field_239371_m_;
    public final VillageSectionsDebugRender field_239372_n_;
    public final BeeDebugRenderer field_229017_n_;
    public final RaidDebugRenderer field_222927_n;
    public final EntityAIDebugRenderer field_217742_n;
    public final GameTestDebugRenderer field_229018_q_;
    private boolean chunkBorderEnabled;

    public DebugRenderer(Minecraft clientIn) {
        this.water = new WaterDebugRenderer(clientIn);
        this.chunkBorder = new ChunkBorderDebugRenderer(clientIn);
        this.heightMap = new HeightMapDebugRenderer(clientIn);
        this.collisionBox = new CollisionBoxDebugRenderer(clientIn);
        this.neighborsUpdate = new NeighborsUpdateDebugRenderer(clientIn);
        this.cave = new CaveDebugRenderer();
        this.structure = new StructureDebugRenderer(clientIn);
        this.light = new LightDebugRenderer(clientIn);
        this.worldGenAttempts = new WorldGenAttemptsDebugRenderer();
        this.solidFace = new SolidFaceDebugRenderer(clientIn);
        this.field_217740_l = new ChunkInfoDebugRenderer(clientIn);
        this.field_239371_m_ = new PointOfInterestDebugRenderer(clientIn);
        this.field_239372_n_ = new VillageSectionsDebugRender();
        this.field_229017_n_ = new BeeDebugRenderer(clientIn);
        this.field_222927_n = new RaidDebugRenderer(clientIn);
        this.field_217742_n = new EntityAIDebugRenderer(clientIn);
        this.field_229018_q_ = new GameTestDebugRenderer();
    }

    public void clear() {
        this.pathfinding.clear();
        this.water.clear();
        this.chunkBorder.clear();
        this.heightMap.clear();
        this.collisionBox.clear();
        this.neighborsUpdate.clear();
        this.cave.clear();
        this.structure.clear();
        this.light.clear();
        this.worldGenAttempts.clear();
        this.solidFace.clear();
        this.field_217740_l.clear();
        this.field_239371_m_.clear();
        this.field_239372_n_.clear();
        this.field_229017_n_.clear();
        this.field_222927_n.clear();
        this.field_217742_n.clear();
        this.field_229018_q_.clear();
    }

    public boolean toggleChunkBorders() {
        this.chunkBorderEnabled = !this.chunkBorderEnabled;
        return this.chunkBorderEnabled;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer.Impl bufferIn, double camX, double camY, double camZ) {
        if (this.chunkBorderEnabled && !Minecraft.getInstance().isReducedDebug()) {
            this.chunkBorder.render(matrixStackIn, bufferIn, camX, camY, camZ);
        }
        this.field_229018_q_.render(matrixStackIn, bufferIn, camX, camY, camZ);
    }

    public static Optional<Entity> getTargetEntity(@Nullable Entity entityIn, int distance) {
        int i;
        Predicate<Entity> predicate;
        AxisAlignedBB axisalignedbb;
        Vector3d vector3d1;
        Vector3d vector3d2;
        if (entityIn == null) {
            return Optional.empty();
        }
        Vector3d vector3d = entityIn.getEyePosition(1.0f);
        EntityRayTraceResult entityraytraceresult = ProjectileHelper.rayTraceEntities(entityIn, vector3d, vector3d2 = vector3d.add(vector3d1 = entityIn.getLook(1.0f).scale(distance)), axisalignedbb = entityIn.getBoundingBox().expand(vector3d1).grow(1.0), predicate = p_217727_0_ -> !p_217727_0_.isSpectator() && p_217727_0_.canBeCollidedWith(), i = distance * distance);
        if (entityraytraceresult == null) {
            return Optional.empty();
        }
        return vector3d.squareDistanceTo(entityraytraceresult.getHitVec()) > (double)i ? Optional.empty() : Optional.of(entityraytraceresult.getEntity());
    }

    public static void renderBox(BlockPos p_217735_0_, BlockPos p_217735_1_, float p_217735_2_, float p_217735_3_, float p_217735_4_, float p_217735_5_) {
        ActiveRenderInfo activerenderinfo = Minecraft.getInstance().gameRenderer.getActiveRenderInfo();
        if (activerenderinfo.isValid()) {
            Vector3d vector3d = activerenderinfo.getProjectedView().inverse();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_217735_0_, p_217735_1_).offset(vector3d);
            DebugRenderer.renderBox(axisalignedbb, p_217735_2_, p_217735_3_, p_217735_4_, p_217735_5_);
        }
    }

    public static void renderBox(BlockPos p_217736_0_, float p_217736_1_, float p_217736_2_, float p_217736_3_, float p_217736_4_, float p_217736_5_) {
        ActiveRenderInfo activerenderinfo = Minecraft.getInstance().gameRenderer.getActiveRenderInfo();
        if (activerenderinfo.isValid()) {
            Vector3d vector3d = activerenderinfo.getProjectedView().inverse();
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_217736_0_).offset(vector3d).grow(p_217736_1_);
            DebugRenderer.renderBox(axisalignedbb, p_217736_2_, p_217736_3_, p_217736_4_, p_217736_5_);
        }
    }

    public static void renderBox(AxisAlignedBB p_217730_0_, float p_217730_1_, float p_217730_2_, float p_217730_3_, float p_217730_4_) {
        DebugRenderer.renderBox(p_217730_0_.minX, p_217730_0_.minY, p_217730_0_.minZ, p_217730_0_.maxX, p_217730_0_.maxY, p_217730_0_.maxZ, p_217730_1_, p_217730_2_, p_217730_3_, p_217730_4_);
    }

    public static void renderBox(double p_217733_0_, double p_217733_2_, double p_217733_4_, double p_217733_6_, double p_217733_8_, double p_217733_10_, float p_217733_12_, float p_217733_13_, float p_217733_14_, float p_217733_15_) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(5, DefaultVertexFormats.POSITION_COLOR);
        WorldRenderer.addChainedFilledBoxVertices(bufferbuilder, p_217733_0_, p_217733_2_, p_217733_4_, p_217733_6_, p_217733_8_, p_217733_10_, p_217733_12_, p_217733_13_, p_217733_14_, p_217733_15_);
        tessellator.draw();
    }

    public static void renderText(String p_217731_0_, int p_217731_1_, int p_217731_2_, int p_217731_3_, int p_217731_4_) {
        DebugRenderer.renderText(p_217731_0_, (double)p_217731_1_ + 0.5, (double)p_217731_2_ + 0.5, (double)p_217731_3_ + 0.5, p_217731_4_);
    }

    public static void renderText(String p_217732_0_, double p_217732_1_, double p_217732_3_, double p_217732_5_, int p_217732_7_) {
        DebugRenderer.renderText(p_217732_0_, p_217732_1_, p_217732_3_, p_217732_5_, p_217732_7_, 0.02f);
    }

    public static void renderText(String p_217729_0_, double p_217729_1_, double p_217729_3_, double p_217729_5_, int p_217729_7_, float p_217729_8_) {
        DebugRenderer.renderText(p_217729_0_, p_217729_1_, p_217729_3_, p_217729_5_, p_217729_7_, p_217729_8_, true, 0.0f, false);
    }

    public static void renderText(String textIn, double p_217734_1_, double p_217734_3_, double p_217734_5_, int colorIn, float p_217734_8_, boolean p_217734_9_, float p_217734_10_, boolean p_217734_11_) {
        Minecraft minecraft = Minecraft.getInstance();
        ActiveRenderInfo activerenderinfo = minecraft.gameRenderer.getActiveRenderInfo();
        if (activerenderinfo.isValid() && minecraft.getRenderManager().options != null) {
            FontRenderer fontrenderer = minecraft.fontRenderer;
            double d0 = activerenderinfo.getProjectedView().x;
            double d1 = activerenderinfo.getProjectedView().y;
            double d2 = activerenderinfo.getProjectedView().z;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(p_217734_1_ - d0), (float)(p_217734_3_ - d1) + 0.07f, (float)(p_217734_5_ - d2));
            RenderSystem.normal3f(0.0f, 1.0f, 0.0f);
            RenderSystem.multMatrix(new Matrix4f(activerenderinfo.getRotation()));
            RenderSystem.scalef(p_217734_8_, -p_217734_8_, p_217734_8_);
            RenderSystem.enableTexture();
            if (p_217734_11_) {
                RenderSystem.disableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
            }
            RenderSystem.depthMask(true);
            RenderSystem.scalef(-1.0f, 1.0f, 1.0f);
            float f = p_217734_9_ ? (float)(-fontrenderer.getStringWidth(textIn)) / 2.0f : 0.0f;
            RenderSystem.enableAlphaTest();
            IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.getImpl(Tessellator.getInstance().getBuffer());
            fontrenderer.renderString(textIn, f -= p_217734_10_ / p_217734_8_, 0.0f, colorIn, false, TransformationMatrix.identity().getMatrix(), irendertypebuffer$impl, p_217734_11_, 0, 0xF000F0);
            irendertypebuffer$impl.finish();
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.popMatrix();
        }
    }

    public static interface IDebugRenderer {
        public void render(MatrixStack var1, IRenderTypeBuffer var2, double var3, double var5, double var7);

        default public void clear() {
        }
    }
}

