/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.DefaultColorVertexBuilder;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.Optional;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;

public class OutlineLayerBuffer
implements IRenderTypeBuffer {
    private final IRenderTypeBuffer.Impl buffer;
    private final IRenderTypeBuffer.Impl outlineBuffer = IRenderTypeBuffer.getImpl(new BufferBuilder(256));
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;

    public OutlineLayerBuffer(IRenderTypeBuffer.Impl bufferIn) {
        this.buffer = bufferIn;
    }

    @Override
    public IVertexBuilder getBuffer(RenderType p_getBuffer_1_) {
        if (p_getBuffer_1_.isColoredOutlineBuffer()) {
            IVertexBuilder ivertexbuilder2 = this.outlineBuffer.getBuffer(p_getBuffer_1_);
            return new ColoredOutline(ivertexbuilder2, this.red, this.green, this.blue, this.alpha);
        }
        IVertexBuilder ivertexbuilder = this.buffer.getBuffer(p_getBuffer_1_);
        Optional<RenderType> optional = p_getBuffer_1_.getOutline();
        if (optional.isPresent()) {
            IVertexBuilder ivertexbuilder1 = this.outlineBuffer.getBuffer(optional.get());
            ColoredOutline outlinelayerbuffer$coloredoutline = new ColoredOutline(ivertexbuilder1, this.red, this.green, this.blue, this.alpha);
            return VertexBuilderUtils.newDelegate(outlinelayerbuffer$coloredoutline, ivertexbuilder);
        }
        return ivertexbuilder;
    }

    public void setColor(int redIn, int greenIn, int blueIn, int alphaIn) {
        this.red = redIn;
        this.green = greenIn;
        this.blue = blueIn;
        this.alpha = alphaIn;
    }

    public void finish() {
        this.outlineBuffer.finish();
    }

    static class ColoredOutline
    extends DefaultColorVertexBuilder {
        private final IVertexBuilder coloredBuffer;
        private double x;
        private double y;
        private double z;
        private float u;
        private float v;

        private ColoredOutline(IVertexBuilder bufferIn, int red, int green, int blue, int alpha) {
            this.coloredBuffer = bufferIn;
            super.setDefaultColor(red, green, blue, alpha);
        }

        @Override
        public void setDefaultColor(int red, int green, int blue, int alpha) {
        }

        @Override
        public IVertexBuilder pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        @Override
        public IVertexBuilder color(int red, int green, int blue, int alpha) {
            return this;
        }

        @Override
        public IVertexBuilder tex(float u, float v) {
            this.u = u;
            this.v = v;
            return this;
        }

        @Override
        public IVertexBuilder overlay(int u, int v) {
            return this;
        }

        @Override
        public IVertexBuilder lightmap(int u, int v) {
            return this;
        }

        @Override
        public IVertexBuilder normal(float x, float y, float z) {
            return this;
        }

        @Override
        public void addVertex(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
            this.coloredBuffer.pos(x, y, z).color(this.defaultRed, this.defaultGreen, this.defaultBlue, this.defaultAlpha).tex(texU, texV).endVertex();
        }

        @Override
        public void endVertex() {
            this.coloredBuffer.pos(this.x, this.y, this.z).color(this.defaultRed, this.defaultGreen, this.defaultBlue, this.defaultAlpha).tex(this.u, this.v).endVertex();
        }
    }
}

