/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ItemModelMesher {
    public final Int2ObjectMap<ModelResourceLocation> modelLocations = new Int2ObjectOpenHashMap<ModelResourceLocation>(256);
    private final Int2ObjectMap<IBakedModel> itemModels = new Int2ObjectOpenHashMap<IBakedModel>(256);
    private final ModelManager modelManager;

    public ItemModelMesher(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public TextureAtlasSprite getParticleIcon(IItemProvider itemProvider) {
        return this.getParticleIcon(new ItemStack(itemProvider));
    }

    public TextureAtlasSprite getParticleIcon(ItemStack stack) {
        IBakedModel ibakedmodel = this.getItemModel(stack);
        return ibakedmodel == this.modelManager.getMissingModel() && stack.getItem() instanceof BlockItem ? this.modelManager.getBlockModelShapes().getTexture(((BlockItem)stack.getItem()).getBlock().getDefaultState()) : ibakedmodel.getParticleTexture();
    }

    public IBakedModel getItemModel(ItemStack stack) {
        IBakedModel ibakedmodel = this.getItemModel(stack.getItem());
        return ibakedmodel == null ? this.modelManager.getMissingModel() : ibakedmodel;
    }

    @Nullable
    public IBakedModel getItemModel(Item itemIn) {
        return (IBakedModel)this.itemModels.get(ItemModelMesher.getIndex(itemIn));
    }

    private static int getIndex(Item itemIn) {
        return Item.getIdFromItem(itemIn);
    }

    public void register(Item itemIn, ModelResourceLocation modelLocation) {
        this.modelLocations.put(ItemModelMesher.getIndex(itemIn), modelLocation);
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void rebuildCache() {
        this.itemModels.clear();
        for (Map.Entry entry : this.modelLocations.entrySet()) {
            this.itemModels.put((Integer)entry.getKey(), this.modelManager.getModel((ModelResourceLocation)entry.getValue()));
        }
    }
}

