/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;

public class FluidBlockRenderer {
    private final TextureAtlasSprite[] atlasSpritesLava = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] atlasSpritesWater = new TextureAtlasSprite[2];
    private TextureAtlasSprite atlasSpriteWaterOverlay;

    protected void initAtlasSprites() {
        this.atlasSpritesLava[0] = Minecraft.getInstance().getModelManager().getBlockModelShapes().getModel(Blocks.LAVA.getDefaultState()).getParticleTexture();
        this.atlasSpritesLava[1] = ModelBakery.LOCATION_LAVA_FLOW.getSprite();
        this.atlasSpritesWater[0] = Minecraft.getInstance().getModelManager().getBlockModelShapes().getModel(Blocks.WATER.getDefaultState()).getParticleTexture();
        this.atlasSpritesWater[1] = ModelBakery.LOCATION_WATER_FLOW.getSprite();
        this.atlasSpriteWaterOverlay = ModelBakery.LOCATION_WATER_OVERLAY.getSprite();
    }

    private static boolean isAdjacentFluidSameAs(IBlockReader worldIn, BlockPos pos, Direction side, FluidState state) {
        BlockPos blockpos = pos.offset(side);
        FluidState fluidstate = worldIn.getFluidState(blockpos);
        return fluidstate.getFluid().isEquivalentTo(state.getFluid());
    }

    private static boolean func_239284_a_(IBlockReader p_239284_0_, Direction p_239284_1_, float p_239284_2_, BlockPos p_239284_3_, BlockState p_239284_4_) {
        if (p_239284_4_.isSolid()) {
            VoxelShape voxelshape = VoxelShapes.create(0.0, 0.0, 0.0, 1.0, p_239284_2_, 1.0);
            VoxelShape voxelshape1 = p_239284_4_.getRenderShapeTrue(p_239284_0_, p_239284_3_);
            return VoxelShapes.isCubeSideCovered(voxelshape, voxelshape1, p_239284_1_);
        }
        return false;
    }

    private static boolean func_239283_a_(IBlockReader p_239283_0_, BlockPos p_239283_1_, Direction p_239283_2_, float p_239283_3_) {
        BlockPos blockpos = p_239283_1_.offset(p_239283_2_);
        BlockState blockstate = p_239283_0_.getBlockState(blockpos);
        return FluidBlockRenderer.func_239284_a_(p_239283_0_, p_239283_2_, p_239283_3_, blockpos, blockstate);
    }

    private static boolean func_239282_a_(IBlockReader p_239282_0_, BlockPos p_239282_1_, BlockState p_239282_2_, Direction p_239282_3_) {
        return FluidBlockRenderer.func_239284_a_(p_239282_0_, p_239282_3_.getOpposite(), 1.0f, p_239282_1_, p_239282_2_);
    }

    public static boolean func_239281_a_(IBlockDisplayReader p_239281_0_, BlockPos p_239281_1_, FluidState p_239281_2_, BlockState p_239281_3_, Direction p_239281_4_) {
        return !FluidBlockRenderer.func_239282_a_(p_239281_0_, p_239281_1_, p_239281_3_, p_239281_4_) && !FluidBlockRenderer.isAdjacentFluidSameAs(p_239281_0_, p_239281_1_, p_239281_4_, p_239281_2_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(IBlockDisplayReader lightReaderIn, BlockPos posIn, IVertexBuilder vertexBuilderIn, FluidState fluidStateIn) {
        boolean flag7;
        BlockState blockstate = fluidStateIn.getBlockState();
        try {
            Object object;
            TextureAtlasSprite[] atextureatlassprite1;
            boolean flag;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity(blockstate, vertexBuilderIn);
            }
            TextureAtlasSprite[] atextureatlassprite = (flag = fluidStateIn.isTagged(FluidTags.LAVA)) ? this.atlasSpritesLava : this.atlasSpritesWater;
            BlockState blockstate1 = lightReaderIn.getBlockState(posIn);
            if (Reflector.ForgeHooksClient_getFluidSprites.exists() && (atextureatlassprite1 = (TextureAtlasSprite[])Reflector.call(Reflector.ForgeHooksClient_getFluidSprites, lightReaderIn, posIn, fluidStateIn)) != null) {
                atextureatlassprite = atextureatlassprite1;
            }
            RenderEnv renderenv = vertexBuilderIn.getRenderEnv(blockstate, posIn);
            int i = -1;
            float f = 1.0f;
            if (Reflector.IForgeFluid_getAttributes.exists() && (object = Reflector.call(fluidStateIn.getFluid(), Reflector.IForgeFluid_getAttributes, new Object[0])) != null && Reflector.FluidAttributes_getColor.exists()) {
                i = Reflector.callInt(object, Reflector.FluidAttributes_getColor, lightReaderIn, posIn);
                f = (float)(i >> 24 & 0xFF) / 255.0f;
            }
            boolean flag9 = !FluidBlockRenderer.isAdjacentFluidSameAs(lightReaderIn, posIn, Direction.UP, fluidStateIn);
            boolean flag1 = FluidBlockRenderer.func_239281_a_(lightReaderIn, posIn, fluidStateIn, blockstate1, Direction.DOWN) && !FluidBlockRenderer.func_239283_a_(lightReaderIn, posIn, Direction.DOWN, 0.8888889f);
            boolean flag2 = FluidBlockRenderer.func_239281_a_(lightReaderIn, posIn, fluidStateIn, blockstate1, Direction.NORTH);
            boolean flag3 = FluidBlockRenderer.func_239281_a_(lightReaderIn, posIn, fluidStateIn, blockstate1, Direction.SOUTH);
            boolean flag4 = FluidBlockRenderer.func_239281_a_(lightReaderIn, posIn, fluidStateIn, blockstate1, Direction.WEST);
            boolean flag5 = FluidBlockRenderer.func_239281_a_(lightReaderIn, posIn, fluidStateIn, blockstate1, Direction.EAST);
            if (flag9 || flag1 || flag5 || flag4 || flag2 || flag3) {
                float f30;
                if (i < 0) {
                    i = CustomColors.getFluidColor(lightReaderIn, blockstate, posIn, renderenv);
                }
                float f28 = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                boolean flag72 = false;
                float f3 = lightReaderIn.func_230487_a_(Direction.DOWN, true);
                float f4 = lightReaderIn.func_230487_a_(Direction.UP, true);
                float f5 = lightReaderIn.func_230487_a_(Direction.NORTH, true);
                float f6 = lightReaderIn.func_230487_a_(Direction.WEST, true);
                float f7 = this.getFluidHeight(lightReaderIn, posIn, fluidStateIn.getFluid());
                float f8 = this.getFluidHeight(lightReaderIn, posIn.south(), fluidStateIn.getFluid());
                float f9 = this.getFluidHeight(lightReaderIn, posIn.east().south(), fluidStateIn.getFluid());
                float f10 = this.getFluidHeight(lightReaderIn, posIn.east(), fluidStateIn.getFluid());
                double d0 = posIn.getX() & 0xF;
                double d1 = posIn.getY() & 0xF;
                double d2 = posIn.getZ() & 0xF;
                if (Config.isRenderRegions()) {
                    int j = posIn.getX() >> 4 << 4;
                    int k = posIn.getY() >> 4 << 4;
                    int l = posIn.getZ() >> 4 << 4;
                    int i1 = 8;
                    int j1 = j >> i1 << i1;
                    int k1 = l >> i1 << i1;
                    int l1 = j - j1;
                    int i2 = l - k1;
                    d0 += (double)l1;
                    d1 += (double)k;
                    d2 += (double)i2;
                }
                if (Config.isShaders() && Shaders.useMidBlockAttrib) {
                    vertexBuilderIn.setMidBlock((float)(d0 + 0.5), (float)(d1 + 0.5), (float)(d2 + 0.5));
                }
                float f29 = 0.001f;
                float f11 = f30 = flag1 ? 0.001f : 0.0f;
                if (flag9 && !FluidBlockRenderer.func_239283_a_(lightReaderIn, posIn, Direction.UP, Math.min(Math.min(f7, f8), Math.min(f9, f10)))) {
                    float f13;
                    float f40;
                    float f12;
                    float f38;
                    float f42;
                    float f35;
                    float f112;
                    float f32;
                    flag72 = true;
                    f7 -= 0.001f;
                    f8 -= 0.001f;
                    f9 -= 0.001f;
                    f10 -= 0.001f;
                    Vector3d vector3d = fluidStateIn.getFlow(lightReaderIn, posIn);
                    if (vector3d.x == 0.0 && vector3d.z == 0.0) {
                        TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                        vertexBuilderIn.setSprite(textureatlassprite1);
                        f32 = textureatlassprite1.getInterpolatedU(0.0);
                        f112 = textureatlassprite1.getInterpolatedV(0.0);
                        f35 = f32;
                        f42 = textureatlassprite1.getInterpolatedV(16.0);
                        f38 = textureatlassprite1.getInterpolatedU(16.0);
                        f12 = f42;
                        f40 = f38;
                        f13 = f112;
                    } else {
                        TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                        vertexBuilderIn.setSprite(textureatlassprite);
                        float f14 = (float)MathHelper.atan2(vector3d.z, vector3d.x) - 1.5707964f;
                        float f15 = MathHelper.sin(f14) * 0.25f;
                        float f16 = MathHelper.cos(f14) * 0.25f;
                        float f17 = 8.0f;
                        f32 = textureatlassprite.getInterpolatedU(8.0f + (-f16 - f15) * 16.0f);
                        f112 = textureatlassprite.getInterpolatedV(8.0f + (-f16 + f15) * 16.0f);
                        f35 = textureatlassprite.getInterpolatedU(8.0f + (-f16 + f15) * 16.0f);
                        f42 = textureatlassprite.getInterpolatedV(8.0f + (f16 + f15) * 16.0f);
                        f38 = textureatlassprite.getInterpolatedU(8.0f + (f16 + f15) * 16.0f);
                        f12 = textureatlassprite.getInterpolatedV(8.0f + (f16 - f15) * 16.0f);
                        f40 = textureatlassprite.getInterpolatedU(8.0f + (f16 - f15) * 16.0f);
                        f13 = textureatlassprite.getInterpolatedV(8.0f + (-f16 - f15) * 16.0f);
                    }
                    float f46 = (f32 + f35 + f38 + f40) / 4.0f;
                    float f47 = (f112 + f42 + f12 + f13) / 4.0f;
                    float f48 = (float)atextureatlassprite[0].getWidth() / (atextureatlassprite[0].getMaxU() - atextureatlassprite[0].getMinU());
                    float f49 = (float)atextureatlassprite[0].getHeight() / (atextureatlassprite[0].getMaxV() - atextureatlassprite[0].getMinV());
                    float f50 = 4.0f / Math.max(f49, f48);
                    f32 = MathHelper.lerp(f50, f32, f46);
                    f35 = MathHelper.lerp(f50, f35, f46);
                    f38 = MathHelper.lerp(f50, f38, f46);
                    f40 = MathHelper.lerp(f50, f40, f46);
                    f112 = MathHelper.lerp(f50, f112, f47);
                    f42 = MathHelper.lerp(f50, f42, f47);
                    f12 = MathHelper.lerp(f50, f12, f47);
                    f13 = MathHelper.lerp(f50, f13, f47);
                    int j2 = this.getCombinedAverageLight(lightReaderIn, posIn);
                    float f18 = f4 * f28;
                    float f19 = f4 * f1;
                    float f20 = f4 * f2;
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f18, f19, f20, f, f32, f112, j2);
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f18, f19, f20, f, f35, f42, j2);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f18, f19, f20, f, f38, f12, j2);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f18, f19, f20, f, f40, f13, j2);
                    if (fluidStateIn.shouldRenderSides(lightReaderIn, posIn.up())) {
                        this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f18, f19, f20, f, f32, f112, j2);
                        this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f18, f19, f20, f, f40, f13, j2);
                        this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f18, f19, f20, f, f38, f12, j2);
                        this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f18, f19, f20, f, f35, f42, j2);
                    }
                }
                if (flag1) {
                    vertexBuilderIn.setSprite(atextureatlassprite[0]);
                    float f31 = atextureatlassprite[0].getMinU();
                    float f33 = atextureatlassprite[0].getMaxU();
                    float f36 = atextureatlassprite[0].getMinV();
                    float f39 = atextureatlassprite[0].getMaxV();
                    int i3 = this.getCombinedAverageLight(lightReaderIn, posIn.down());
                    float f41 = lightReaderIn.func_230487_a_(Direction.DOWN, true);
                    float f43 = f41 * f28;
                    float f44 = f41 * f1;
                    float f45 = f41 * f2;
                    this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f30, d2 + 1.0, f43, f44, f45, f, f31, f39, i3);
                    this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f30, d2, f43, f44, f45, f, f31, f36, i3);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f30, d2, f43, f44, f45, f, f33, f36, i3);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f30, d2 + 1.0, f43, f44, f45, f, f33, f39, i3);
                    flag72 = true;
                }
                for (int l2 = 0; l2 < 4; ++l2) {
                    boolean flag11;
                    boolean flag10;
                    Direction direction;
                    double d6;
                    double d4;
                    double d5;
                    double d3;
                    float f37;
                    float f34;
                    if (l2 == 0) {
                        f34 = f7;
                        f37 = f10;
                        d3 = d0;
                        d5 = d0 + 1.0;
                        d4 = d2 + (double)0.001f;
                        d6 = d2 + (double)0.001f;
                        direction = Direction.NORTH;
                        flag10 = flag2;
                    } else if (l2 == 1) {
                        f34 = f9;
                        f37 = f8;
                        d3 = d0 + 1.0;
                        d5 = d0;
                        d4 = d2 + 1.0 - (double)0.001f;
                        d6 = d2 + 1.0 - (double)0.001f;
                        direction = Direction.SOUTH;
                        flag10 = flag3;
                    } else if (l2 == 2) {
                        f34 = f8;
                        f37 = f7;
                        d3 = d0 + (double)0.001f;
                        d5 = d0 + (double)0.001f;
                        d4 = d2 + 1.0;
                        d6 = d2;
                        direction = Direction.WEST;
                        flag10 = flag4;
                    } else {
                        f34 = f10;
                        f37 = f9;
                        d3 = d0 + 1.0 - (double)0.001f;
                        d5 = d0 + 1.0 - (double)0.001f;
                        d4 = d2;
                        d6 = d2 + 1.0;
                        direction = Direction.EAST;
                        flag10 = flag5;
                    }
                    if (!flag10 || FluidBlockRenderer.func_239283_a_(lightReaderIn, posIn, direction, Math.max(f34, f37))) continue;
                    flag72 = true;
                    BlockPos blockpos = posIn.offset(direction);
                    TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
                    float f51 = 0.0f;
                    float f52 = 0.0f;
                    boolean bl = flag11 = !flag;
                    if (Reflector.IForgeBlockState_shouldDisplayFluidOverlay.exists()) {
                        boolean bl2 = flag11 = atextureatlassprite[2] != null;
                    }
                    if (flag11) {
                        BlockState blockstate2 = lightReaderIn.getBlockState(blockpos);
                        Block block = blockstate2.getBlock();
                        boolean flag8 = false;
                        if (Reflector.IForgeBlockState_shouldDisplayFluidOverlay.exists()) {
                            flag8 = Reflector.callBoolean(blockstate2, Reflector.IForgeBlockState_shouldDisplayFluidOverlay, lightReaderIn, blockpos, fluidStateIn);
                        }
                        if (flag8 || block instanceof BreakableBlock || block instanceof LeavesBlock || block == Blocks.BEACON) {
                            textureatlassprite2 = this.atlasSpriteWaterOverlay;
                        }
                        if (block == Blocks.FARMLAND || block == Blocks.GRASS_PATH) {
                            f51 = 0.9375f;
                            f52 = 0.9375f;
                        }
                        if (block instanceof SlabBlock) {
                            SlabBlock slabblock = (SlabBlock)block;
                            if (blockstate2.get(SlabBlock.TYPE) == SlabType.BOTTOM) {
                                f51 = 0.5f;
                                f52 = 0.5f;
                            }
                        }
                    }
                    vertexBuilderIn.setSprite(textureatlassprite2);
                    if (f34 <= f51 && f37 <= f52) continue;
                    f51 = Math.min(f51, f34);
                    f52 = Math.min(f52, f37);
                    if (f51 > f29) {
                        f51 -= f29;
                    }
                    if (f52 > f29) {
                        f52 -= f29;
                    }
                    float f53 = textureatlassprite2.getInterpolatedV((1.0f - f51) * 16.0f * 0.5f);
                    float f54 = textureatlassprite2.getInterpolatedV((1.0f - f52) * 16.0f * 0.5f);
                    float f55 = textureatlassprite2.getInterpolatedU(0.0);
                    float f56 = textureatlassprite2.getInterpolatedU(8.0);
                    float f21 = textureatlassprite2.getInterpolatedV((1.0f - f34) * 16.0f * 0.5f);
                    float f22 = textureatlassprite2.getInterpolatedV((1.0f - f37) * 16.0f * 0.5f);
                    float f23 = textureatlassprite2.getInterpolatedV(8.0);
                    int k2 = this.getCombinedAverageLight(lightReaderIn, blockpos);
                    float f24 = l2 < 2 ? lightReaderIn.func_230487_a_(Direction.NORTH, true) : lightReaderIn.func_230487_a_(Direction.WEST, true);
                    float f25 = 1.0f * f24 * f28;
                    float f26 = 1.0f * f24 * f1;
                    float f27 = 1.0f * f24 * f2;
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f34, d4, f25, f26, f27, f, f55, f21, k2);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f37, d6, f25, f26, f27, f, f56, f22, k2);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f30, d6, f25, f26, f27, f, f56, f54, k2);
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f30, d4, f25, f26, f27, f, f55, f53, k2);
                    if (textureatlassprite2 == this.atlasSpriteWaterOverlay) continue;
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f30, d4, f25, f26, f27, f, f55, f53, k2);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f30, d6, f25, f26, f27, f, f56, f54, k2);
                    this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f37, d6, f25, f26, f27, f, f56, f22, k2);
                    this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f34, d4, f25, f26, f27, f, f55, f21, k2);
                }
                vertexBuilderIn.setSprite(null);
                boolean bl = flag72;
                return bl;
            }
            flag7 = false;
        }
        finally {
            if (Config.isShaders()) {
                SVertexBuilder.popEntity(vertexBuilderIn);
            }
        }
        return flag7;
    }

    private void vertexVanilla(IVertexBuilder vertexBuilderIn, double x, double y, double z, float red, float green, float blue, float u, float v, int packedLight) {
        vertexBuilderIn.pos(x, y, z).color(red, green, blue, 1.0f).tex(u, v).lightmap(packedLight).normal(0.0f, 1.0f, 0.0f).endVertex();
    }

    private void vertexVanilla(IVertexBuilder p_vertexVanilla_1_, double p_vertexVanilla_2_, double p_vertexVanilla_4_, double p_vertexVanilla_6_, float p_vertexVanilla_8_, float p_vertexVanilla_9_, float p_vertexVanilla_10_, float p_vertexVanilla_11_, float p_vertexVanilla_12_, float p_vertexVanilla_13_, int p_vertexVanilla_14_) {
        p_vertexVanilla_1_.pos(p_vertexVanilla_2_, p_vertexVanilla_4_, p_vertexVanilla_6_).color(p_vertexVanilla_8_, p_vertexVanilla_9_, p_vertexVanilla_10_, p_vertexVanilla_11_).tex(p_vertexVanilla_12_, p_vertexVanilla_13_).lightmap(p_vertexVanilla_14_).normal(0.0f, 1.0f, 0.0f).endVertex();
    }

    private int getCombinedAverageLight(IBlockDisplayReader lightReaderIn, BlockPos posIn) {
        int i = WorldRenderer.getCombinedLight(lightReaderIn, posIn);
        int j = WorldRenderer.getCombinedLight(lightReaderIn, posIn.up());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    private float getFluidHeight(IBlockReader reader, BlockPos pos, Fluid fluidIn) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.add(-(j & 1), 0, -(j >> 1 & 1));
            if (reader.getFluidState(blockpos.up()).getFluid().isEquivalentTo(fluidIn)) {
                return 1.0f;
            }
            FluidState fluidstate = reader.getFluidState(blockpos);
            if (fluidstate.getFluid().isEquivalentTo(fluidIn)) {
                float f1 = fluidstate.getActualHeight(reader, blockpos);
                if (f1 >= 0.8f) {
                    f += f1 * 10.0f;
                    i += 10;
                    continue;
                }
                f += f1;
                ++i;
                continue;
            }
            if (reader.getBlockState(blockpos).getMaterial().isSolid()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

