/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.toasts;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;

public class ToastGui
extends AbstractGui {
    private final Minecraft mc;
    private final ToastInstance<?>[] visible = new ToastInstance[5];
    private final Deque<IToast> toastsQueue = Queues.newArrayDeque();

    public ToastGui(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void func_238541_a_(MatrixStack p_238541_1_) {
        if (!this.mc.gameSettings.hideGUI) {
            for (int i = 0; i < this.visible.length; ++i) {
                ToastInstance<?> toastinstance = this.visible[i];
                if (toastinstance != null && toastinstance.render(this.mc.getMainWindow().getScaledWidth(), i, p_238541_1_)) {
                    this.visible[i] = null;
                }
                if (this.visible[i] != null || this.toastsQueue.isEmpty()) continue;
                this.visible[i] = new ToastInstance(this, this.toastsQueue.removeFirst());
            }
        }
    }

    @Nullable
    public <T extends IToast> T getToast(Class<? extends T> p_192990_1_, Object p_192990_2_) {
        for (ToastInstance<?> toastinstance : this.visible) {
            if (toastinstance == null || !p_192990_1_.isAssignableFrom(toastinstance.getToast().getClass()) || !toastinstance.getToast().getType().equals(p_192990_2_)) continue;
            return (T)toastinstance.getToast();
        }
        for (IToast itoast : this.toastsQueue) {
            if (!p_192990_1_.isAssignableFrom(itoast.getClass()) || !itoast.getType().equals(p_192990_2_)) continue;
            return (T)itoast;
        }
        return (T)((IToast)null);
    }

    public void clear() {
        Arrays.fill(this.visible, null);
        this.toastsQueue.clear();
    }

    public void add(IToast toastIn) {
        this.toastsQueue.add(toastIn);
    }

    public Minecraft getMinecraft() {
        return this.mc;
    }

    static class ToastInstance<T extends IToast> {
        private final T toast;
        private long animationTime = -1L;
        private long visibleTime = -1L;
        private IToast.Visibility visibility = IToast.Visibility.SHOW;
        final /* synthetic */ ToastGui this$0;

        private ToastInstance(T toastIn) {
            this.this$0 = this$0;
            this.toast = toastIn;
        }

        public T getToast() {
            return this.toast;
        }

        private float getVisibility(long p_193686_1_) {
            float f = MathHelper.clamp((float)(p_193686_1_ - this.animationTime) / 600.0f, 0.0f, 1.0f);
            f *= f;
            return this.visibility == IToast.Visibility.HIDE ? 1.0f - f : f;
        }

        public boolean render(int p_193684_1_, int p_193684_2_, MatrixStack p_193684_3_) {
            long i = Util.milliTime();
            if (this.animationTime == -1L) {
                this.animationTime = i;
                this.visibility.playSound(this.this$0.mc.getSoundHandler());
            }
            if (this.visibility == IToast.Visibility.SHOW && i - this.animationTime <= 600L) {
                this.visibleTime = i;
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)p_193684_1_ - (float)this.toast.func_230445_a_() * this.getVisibility(i), p_193684_2_ * this.toast.func_238540_d_(), 800 + p_193684_2_);
            IToast.Visibility itoast$visibility = this.toast.func_230444_a_(p_193684_3_, this.this$0, i - this.visibleTime);
            RenderSystem.popMatrix();
            if (itoast$visibility != this.visibility) {
                this.animationTime = i - (long)((int)((1.0f - this.getVisibility(i)) * 600.0f));
                this.visibility = itoast$visibility;
                this.visibility.playSound(this.this$0.mc.getSoundHandler());
            }
            return this.visibility == IToast.Visibility.HIDE && i - this.animationTime > 600L;
        }
    }
}

