/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.PackScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldOptionsScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.util.FileUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateWorldScreen
extends Screen {
    private static final Logger field_238935_p_ = LogManager.getLogger();
    private static final ITextComponent field_243417_q = new TranslationTextComponent("selectWorld.gameMode");
    private static final ITextComponent field_243418_r = new TranslationTextComponent("selectWorld.enterSeed");
    private static final ITextComponent field_243419_s = new TranslationTextComponent("selectWorld.seedInfo");
    private static final ITextComponent field_243420_t = new TranslationTextComponent("selectWorld.enterName");
    private static final ITextComponent field_243421_u = new TranslationTextComponent("selectWorld.resultFolder");
    private static final ITextComponent field_243422_v = new TranslationTextComponent("selectWorld.allowCommands.info");
    private final Screen parentScreen;
    private TextFieldWidget worldNameField;
    private String saveDirName;
    private GameMode gameMode = GameMode.SURVIVAL;
    @Nullable
    private GameMode field_228198_g_;
    private Difficulty field_238936_v_ = Difficulty.NORMAL;
    private Difficulty difficulty = Difficulty.NORMAL;
    private boolean allowCheats;
    private boolean allowCheatsWasSetByUser;
    public boolean hardCoreMode;
    protected DatapackCodec datapackCodec;
    @Nullable
    private Path field_238928_A_;
    @Nullable
    private ResourcePackList field_243416_G;
    private boolean inMoreWorldOptionsDisplay;
    private Button btnCreateWorld;
    private Button btnGameMode;
    private Button field_238929_E_;
    private Button btnMoreOptions;
    private Button field_238930_G_;
    private Button field_238931_H_;
    private Button btnAllowCommands;
    private ITextComponent gameModeDesc1;
    private ITextComponent gameModeDesc2;
    private String worldName;
    private GameRules gameRules = new GameRules();
    public final WorldOptionsScreen worldOptionsScreen;

    public CreateWorldScreen(@Nullable Screen p_i242064_1_, WorldSettings p_i242064_2_, DimensionGeneratorSettings dimensionGeneratorSettings, @Nullable Path p_i242064_4_, DatapackCodec p_i242064_5_, DynamicRegistries.Impl dynamicRegistries) {
        this(p_i242064_1_, p_i242064_5_, new WorldOptionsScreen(dynamicRegistries, dimensionGeneratorSettings, BiomeGeneratorTypeScreens.func_239079_a_(dimensionGeneratorSettings), OptionalLong.of(dimensionGeneratorSettings.getSeed())));
        this.worldName = p_i242064_2_.getWorldName();
        this.allowCheats = p_i242064_2_.isCommandsAllowed();
        this.allowCheatsWasSetByUser = true;
        this.difficulty = this.field_238936_v_ = p_i242064_2_.getDifficulty();
        this.gameRules.func_234899_a_(p_i242064_2_.getGameRules(), null);
        if (p_i242064_2_.isHardcoreEnabled()) {
            this.gameMode = GameMode.HARDCORE;
        } else if (p_i242064_2_.getGameType().isSurvivalOrAdventure()) {
            this.gameMode = GameMode.SURVIVAL;
        } else if (p_i242064_2_.getGameType().isCreative()) {
            this.gameMode = GameMode.CREATIVE;
        }
        this.field_238928_A_ = p_i242064_4_;
    }

    public static CreateWorldScreen func_243425_a(@Nullable Screen p_243425_0_) {
        DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.getImpl();
        return new CreateWorldScreen(p_243425_0_, DatapackCodec.VANILLA_CODEC, new WorldOptionsScreen(dynamicregistries$impl, DimensionGeneratorSettings.func_242751_a(dynamicregistries$impl.getRegistry(Registry.DIMENSION_TYPE_KEY), dynamicregistries$impl.getRegistry(Registry.BIOME_KEY), dynamicregistries$impl.getRegistry(Registry.NOISE_SETTINGS_KEY)), Optional.of(BiomeGeneratorTypeScreens.field_239066_a_), OptionalLong.empty()));
    }

    private CreateWorldScreen(@Nullable Screen p_i242063_1_, DatapackCodec p_i242063_2_, WorldOptionsScreen p_i242063_3_) {
        super(new TranslationTextComponent("selectWorld.create"));
        this.parentScreen = p_i242063_1_;
        this.worldName = I18n.format("selectWorld.newWorld", new Object[0]);
        this.datapackCodec = p_i242063_2_;
        this.worldOptionsScreen = p_i242063_3_;
    }

    @Override
    public void tick() {
        this.worldNameField.tick();
        this.worldOptionsScreen.tick();
    }

    @Override
    protected void init() {
        this.minecraft.keyboardListener.enableRepeatEvents(true);
        this.worldNameField = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, (ITextComponent)new TranslationTextComponent("selectWorld.enterName")){

            @Override
            protected IFormattableTextComponent getNarrationMessage() {
                return super.getNarrationMessage().appendString(". ").append(new TranslationTextComponent("selectWorld.resultFolder")).appendString(" ").appendString(CreateWorldScreen.this.saveDirName);
            }
        };
        this.worldNameField.setText(this.worldName);
        this.worldNameField.setResponder(p_214319_1_ -> {
            this.worldName = p_214319_1_;
            this.btnCreateWorld.active = !this.worldNameField.getText().isEmpty();
            this.calcSaveDirName();
        });
        this.children.add(this.worldNameField);
        int i = this.width / 2 - 155;
        int j = this.width / 2 + 5;
        this.worldOptionsScreen.func_239048_a_(this, this.minecraft, this.font);
        this.btnCreateWorld = this.addButton(new Button(i, this.height - 28, 150, 20, new TranslationTextComponent("selectWorld.create"), p_214318_1_ -> this.createWorld()));
        this.btnCreateWorld.active = !this.worldName.isEmpty();
        this.addButton(new Button(j, this.height - 28, 150, 20, DialogTexts.GUI_CANCEL, p_214317_1_ -> this.func_243430_k()));
        this.setFocusedDefault(this.worldNameField);
        this.calcSaveDirName();
    }

    private void func_228199_a_() {
        this.gameModeDesc1 = new TranslationTextComponent("selectWorld.gameMode." + this.gameMode.field_228217_e_ + ".line1");
        this.gameModeDesc2 = new TranslationTextComponent("selectWorld.gameMode." + this.gameMode.field_228217_e_ + ".line2");
    }

    private void calcSaveDirName() {
        this.saveDirName = this.worldNameField.getText().trim();
        if (this.saveDirName.isEmpty()) {
            this.saveDirName = "World";
        }
        try {
            this.saveDirName = FileUtil.findAvailableName(this.minecraft.getSaveLoader().getSavesDir(), this.saveDirName, "");
        }
        catch (Exception exception1) {
            this.saveDirName = "World";
            try {
                this.saveDirName = FileUtil.findAvailableName(this.minecraft.getSaveLoader().getSavesDir(), this.saveDirName, "");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    @Override
    public void onClose() {
        this.minecraft.keyboardListener.enableRepeatEvents(false);
    }

    private void createWorld() {
        this.minecraft.forcedScreenTick(new DirtMessageScreen(new TranslationTextComponent("createWorld.preparing")));
        if (this.func_238960_x_()) {
            WorldSettings worldsettings;
            this.func_243432_s();
            DimensionGeneratorSettings dimensiongeneratorsettings = this.worldOptionsScreen.getDimensionGeneratorSettings(this.hardCoreMode);
            if (dimensiongeneratorsettings.isDebug()) {
                GameRules gamerules = new GameRules();
                gamerules.get(GameRules.DO_DAYLIGHT_CYCLE).set(false, null);
                worldsettings = new WorldSettings(this.worldNameField.getText().trim(), GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gamerules, DatapackCodec.VANILLA_CODEC);
            } else {
                worldsettings = new WorldSettings(this.worldNameField.getText().trim(), this.gameMode.gameType, this.hardCoreMode, this.difficulty, this.allowCheats && !this.hardCoreMode, this.gameRules, this.datapackCodec);
            }
            this.minecraft.createWorld(this.saveDirName, worldsettings, this.worldOptionsScreen.getDynamicRegistries(), dimensiongeneratorsettings);
        }
    }

    private void toggleMoreWorldOptions() {
        this.showMoreWorldOptions(!this.inMoreWorldOptionsDisplay);
    }

    private void func_228200_a_(GameMode p_228200_1_) {
        if (!this.allowCheatsWasSetByUser) {
            boolean bl = this.allowCheats = p_228200_1_ == GameMode.CREATIVE;
        }
        if (p_228200_1_ == GameMode.HARDCORE) {
            this.hardCoreMode = true;
            this.btnAllowCommands.active = false;
            this.worldOptionsScreen.field_239027_a_.active = false;
            this.difficulty = Difficulty.HARD;
            this.field_238929_E_.active = false;
        } else {
            this.hardCoreMode = false;
            this.btnAllowCommands.active = true;
            this.worldOptionsScreen.field_239027_a_.active = true;
            this.difficulty = this.field_238936_v_;
            this.field_238929_E_.active = true;
        }
        this.gameMode = p_228200_1_;
        this.func_228199_a_();
    }

    public void func_238955_g_() {
        this.showMoreWorldOptions(this.inMoreWorldOptionsDisplay);
    }

    private void showMoreWorldOptions(boolean toggle) {
        this.inMoreWorldOptionsDisplay = toggle;
        this.btnGameMode.visible = !this.inMoreWorldOptionsDisplay;
        boolean bl = this.field_238929_E_.visible = !this.inMoreWorldOptionsDisplay;
        if (this.worldOptionsScreen.func_239042_a_()) {
            this.field_238931_H_.visible = false;
            this.btnGameMode.active = false;
            if (this.field_228198_g_ == null) {
                this.field_228198_g_ = this.gameMode;
            }
            this.func_228200_a_(GameMode.DEBUG);
            this.btnAllowCommands.visible = false;
        } else {
            this.btnGameMode.active = true;
            if (this.field_228198_g_ != null) {
                this.func_228200_a_(this.field_228198_g_);
            }
            this.btnAllowCommands.visible = !this.inMoreWorldOptionsDisplay;
            this.field_238931_H_.visible = !this.inMoreWorldOptionsDisplay;
        }
        this.worldOptionsScreen.func_239059_b_(this.inMoreWorldOptionsDisplay);
        this.worldNameField.setVisible(!this.inMoreWorldOptionsDisplay);
        if (this.inMoreWorldOptionsDisplay) {
            this.btnMoreOptions.setMessage(DialogTexts.GUI_DONE);
        } else {
            this.btnMoreOptions.setMessage(new TranslationTextComponent("selectWorld.moreWorldOptions"));
        }
        this.field_238930_G_.visible = !this.inMoreWorldOptionsDisplay;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            return false;
        }
        this.createWorld();
        return true;
    }

    @Override
    public void closeScreen() {
        if (this.inMoreWorldOptionsDisplay) {
            this.showMoreWorldOptions(false);
        } else {
            this.func_243430_k();
        }
    }

    public void func_243430_k() {
        this.minecraft.displayGuiScreen(this.parentScreen);
        this.func_243432_s();
    }

    private void func_243432_s() {
        if (this.field_243416_G != null) {
            this.field_243416_G.close();
        }
        this.func_238959_w_();
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack);
        CreateWorldScreen.drawCenteredString(matrixStack, this.font, this.title, this.width / 2, 20, -1);
        if (this.inMoreWorldOptionsDisplay) {
            CreateWorldScreen.drawString(matrixStack, this.font, field_243418_r, this.width / 2 - 100, 47, -6250336);
            CreateWorldScreen.drawString(matrixStack, this.font, field_243419_s, this.width / 2 - 100, 85, -6250336);
            this.worldOptionsScreen.render(matrixStack, mouseX, mouseY, partialTicks);
        } else {
            this.worldNameField.render(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected <T extends IGuiEventListener> T addListener(T listener) {
        return super.addListener(listener);
    }

    @Override
    protected <T extends Widget> T addButton(T button) {
        return super.addButton(button);
    }

    @Nullable
    protected Path func_238957_j_() {
        if (this.field_238928_A_ == null) {
            try {
                this.field_238928_A_ = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                field_238935_p_.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.func_238539_c_(this.minecraft, this.saveDirName);
                this.func_243430_k();
            }
        }
        return this.field_238928_A_;
    }

    private void func_238958_v_() {
        Pair<File, ResourcePackList> pair = this.func_243423_B();
        if (pair != null) {
            this.minecraft.displayGuiScreen(new PackScreen(this, pair.getSecond(), this::func_241621_a_, pair.getFirst(), new TranslationTextComponent("dataPack.title")));
        }
    }

    private void func_241621_a_(ResourcePackList p_241621_1_) {
        ImmutableList<String> list = ImmutableList.copyOf(p_241621_1_.func_232621_d_());
        List list1 = p_241621_1_.func_232616_b_().stream().filter(p_241626_1_ -> !list.contains(p_241626_1_)).collect(ImmutableList.toImmutableList());
        DatapackCodec datapackcodec = new DatapackCodec(list, list1);
        if (list.equals(this.datapackCodec.getEnabled())) {
            this.datapackCodec = datapackcodec;
        } else {
            this.minecraft.enqueue(() -> this.minecraft.displayGuiScreen(new DirtMessageScreen(new TranslationTextComponent("dataPack.validation.working"))));
            DataPackRegistries.func_240961_a_(p_241621_1_.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.getServerExecutor(), this.minecraft).handle((p_241623_2_, p_241623_3_) -> {
                if (p_241623_3_ != null) {
                    field_238935_p_.warn("Failed to validate datapack", (Throwable)p_241623_3_);
                    this.minecraft.enqueue(() -> this.minecraft.displayGuiScreen(new ConfirmScreen(p_241630_1_ -> {
                        if (p_241630_1_) {
                            this.func_238958_v_();
                        } else {
                            this.datapackCodec = DatapackCodec.VANILLA_CODEC;
                            this.minecraft.displayGuiScreen(this);
                        }
                    }, new TranslationTextComponent("dataPack.validation.failed"), StringTextComponent.EMPTY, new TranslationTextComponent("dataPack.validation.back"), new TranslationTextComponent("dataPack.validation.reset"))));
                } else {
                    this.minecraft.enqueue(() -> {
                        this.datapackCodec = datapackcodec;
                        this.worldOptionsScreen.func_243447_a((DataPackRegistries)p_241623_2_);
                        p_241623_2_.close();
                        this.minecraft.displayGuiScreen(this);
                    });
                }
                return null;
            });
        }
    }

    private void func_238959_w_() {
        if (this.field_238928_A_ != null) {
            try (Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_238948_0_ -> {
                    try {
                        Files.delete(p_238948_0_);
                    }
                    catch (IOException ioexception1) {
                        field_238935_p_.warn("Failed to remove temporary file {}", p_238948_0_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                field_238935_p_.warn("Failed to list temporary dir {}", (Object)this.field_238928_A_);
            }
            this.field_238928_A_ = null;
        }
    }

    private static void func_238945_a_(Path p_238945_0_, Path p_238945_1_, Path p_238945_2_) {
        try {
            Util.func_240984_a_(p_238945_0_, p_238945_1_, p_238945_2_);
        }
        catch (IOException ioexception) {
            field_238935_p_.warn("Failed to copy datapack file from {} to {}", (Object)p_238945_2_, (Object)p_238945_1_);
            throw new DatapackException(ioexception);
        }
    }

    private boolean func_238960_x_() {
        if (this.field_238928_A_ != null) {
            try (SaveFormat.LevelSave saveformat$levelsave = this.minecraft.getSaveLoader().getLevelSave(this.saveDirName);
                 Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                Path path = saveformat$levelsave.resolveFilePath(FolderName.DATAPACKS);
                Files.createDirectories(path, new FileAttribute[0]);
                stream.filter(p_238942_1_ -> !p_238942_1_.equals(this.field_238928_A_)).forEach(p_238949_2_ -> CreateWorldScreen.func_238945_a_(this.field_238928_A_, path, p_238949_2_));
            }
            catch (IOException | DatapackException ioexception) {
                field_238935_p_.warn("Failed to copy datapacks to world {}", (Object)this.saveDirName, (Object)ioexception);
                SystemToast.func_238539_c_(this.minecraft, this.saveDirName);
                this.func_243430_k();
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Path func_238943_a_(Path p_238943_0_, Minecraft p_238943_1_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_238943_0_, new FileVisitOption[0]);){
            stream.filter(p_238944_1_ -> !p_238944_1_.equals(p_238943_0_)).forEach(p_238947_2_ -> {
                Path path = (Path)mutableobject.getValue();
                if (path == null) {
                    try {
                        path = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        field_238935_p_.warn("Failed to create temporary dir");
                        throw new DatapackException(ioexception1);
                    }
                    mutableobject.setValue(path);
                }
                CreateWorldScreen.func_238945_a_(p_238943_0_, path, p_238947_2_);
            });
        }
        catch (IOException | DatapackException ioexception) {
            field_238935_p_.warn("Failed to copy datapacks from world {}", (Object)p_238943_0_, (Object)ioexception);
            SystemToast.func_238539_c_(p_238943_1_, p_238943_0_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @Nullable
    private Pair<File, ResourcePackList> func_243423_B() {
        Path path = this.func_238957_j_();
        if (path != null) {
            File file1 = path.toFile();
            if (this.field_243416_G == null) {
                this.field_243416_G = new ResourcePackList(new ServerPackFinder(), new FolderPackFinder(file1, IPackNameDecorator.PLAIN));
                this.field_243416_G.reloadPacksFromFinders();
            }
            this.field_243416_G.setEnabledPacks(this.datapackCodec.getEnabled());
            return Pair.of(file1, this.field_243416_G);
        }
        return null;
    }

    static enum GameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        private final String field_228217_e_;
        private final GameType gameType;

        private GameMode(String p_i225940_3_, GameType p_i225940_4_) {
            this.field_228217_e_ = p_i225940_3_;
            this.gameType = p_i225940_4_;
        }
    }

    static class DatapackException
    extends RuntimeException {
        public DatapackException(Throwable p_i232309_1_) {
            super(p_i232309_1_);
        }
    }
}

