/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.overlay;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;

public class PlayerTabOverlayGui
extends AbstractGui {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from(new PlayerComparator());
    private final Minecraft mc;
    private final IngameGui guiIngame;
    private ITextComponent footer;
    private ITextComponent header;
    private long lastTimeOpened;
    private boolean visible;

    public PlayerTabOverlayGui(Minecraft mcIn, IngameGui guiIngameIn) {
        this.mc = mcIn;
        this.guiIngame = guiIngameIn;
    }

    public ITextComponent getDisplayName(NetworkPlayerInfo p_200262_1_) {
        return p_200262_1_.getDisplayName() != null ? this.func_238524_a_(p_200262_1_, p_200262_1_.getDisplayName().deepCopy()) : this.func_238524_a_(p_200262_1_, ScorePlayerTeam.func_237500_a_(p_200262_1_.getPlayerTeam(), new StringTextComponent(p_200262_1_.getGameProfile().getName())));
    }

    private ITextComponent func_238524_a_(NetworkPlayerInfo p_238524_1_, IFormattableTextComponent p_238524_2_) {
        return p_238524_1_.getGameType() == GameType.SPECTATOR ? p_238524_2_.mergeStyle(TextFormatting.ITALIC) : p_238524_2_;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.visible) {
            this.lastTimeOpened = Util.milliTime();
        }
        this.visible = visible;
    }

    public void func_238523_a_(MatrixStack p_238523_1_, int p_238523_2_, Scoreboard p_238523_3_, @Nullable ScoreObjective p_238523_4_) {
        boolean flag;
        int i4;
        ClientPlayNetHandler clientplaynethandler = this.mc.player.connection;
        List<NetworkPlayerInfo> list = ENTRY_ORDERING.sortedCopy(clientplaynethandler.getPlayerInfoMap());
        int i = 0;
        int j = 0;
        for (NetworkPlayerInfo networkplayerinfo : list) {
            int k = this.mc.fontRenderer.getStringPropertyWidth(this.getDisplayName(networkplayerinfo));
            i = Math.max(i, k);
            if (p_238523_4_ == null || p_238523_4_.getRenderType() == ScoreCriteria.RenderType.HEARTS) continue;
            k = this.mc.fontRenderer.getStringWidth(" " + p_238523_3_.getOrCreateScore(networkplayerinfo.getGameProfile().getName(), p_238523_4_).getScorePoints());
            j = Math.max(j, k);
        }
        list = list.subList(0, Math.min(list.size(), 80));
        int j4 = i4 = list.size();
        int k4 = 1;
        while (j4 > 20) {
            j4 = (i4 + ++k4 - 1) / k4;
        }
        boolean bl = flag = this.mc.isIntegratedServerRunning() || this.mc.getConnection().getNetworkManager().isEncrypted();
        int l = p_238523_4_ != null ? (p_238523_4_.getRenderType() == ScoreCriteria.RenderType.HEARTS ? 90 : j) : 0;
        int i1 = Math.min(k4 * ((flag ? 9 : 0) + i + l + 13), p_238523_2_ - 50) / k4;
        int j1 = p_238523_2_ / 2 - (i1 * k4 + (k4 - 1) * 5) / 2;
        int k1 = 10;
        int l1 = i1 * k4 + (k4 - 1) * 5;
        List<IReorderingProcessor> list1 = null;
        if (this.header != null) {
            list1 = this.mc.fontRenderer.trimStringToWidth(this.header, p_238523_2_ - 50);
            for (IReorderingProcessor iReorderingProcessor : list1) {
                l1 = Math.max(l1, this.mc.fontRenderer.func_243245_a(iReorderingProcessor));
            }
        }
        List<IReorderingProcessor> list2 = null;
        if (this.footer != null) {
            list2 = this.mc.fontRenderer.trimStringToWidth(this.footer, p_238523_2_ - 50);
            for (IReorderingProcessor ireorderingprocessor1 : list2) {
                l1 = Math.max(l1, this.mc.fontRenderer.func_243245_a(ireorderingprocessor1));
            }
        }
        if (list1 != null) {
            PlayerTabOverlayGui.fill(p_238523_1_, p_238523_2_ / 2 - l1 / 2 - 1, k1 - 1, p_238523_2_ / 2 + l1 / 2 + 1, k1 + list1.size() * 9, Integer.MIN_VALUE);
            for (IReorderingProcessor ireorderingprocessor2 : list1) {
                int i2 = this.mc.fontRenderer.func_243245_a(ireorderingprocessor2);
                this.mc.fontRenderer.func_238407_a_(p_238523_1_, ireorderingprocessor2, p_238523_2_ / 2 - i2 / 2, k1, -1);
                k1 += 9;
            }
            ++k1;
        }
        PlayerTabOverlayGui.fill(p_238523_1_, p_238523_2_ / 2 - l1 / 2 - 1, k1 - 1, p_238523_2_ / 2 + l1 / 2 + 1, k1 + j4 * 9, Integer.MIN_VALUE);
        int n = this.mc.gameSettings.getChatBackgroundColor(0x20FFFFFF);
        for (int i5 = 0; i5 < i4; ++i5) {
            int l5;
            int i6;
            int j5 = i5 / j4;
            int j2 = i5 % j4;
            int k2 = j1 + j5 * i1 + j5 * 5;
            int l2 = k1 + j2 * 9;
            PlayerTabOverlayGui.fill(p_238523_1_, k2, l2, k2 + i1, l2 + 8, n);
            RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (i5 >= list.size()) continue;
            NetworkPlayerInfo networkplayerinfo1 = list.get(i5);
            GameProfile gameprofile = networkplayerinfo1.getGameProfile();
            if (flag) {
                PlayerEntity playerentity = this.mc.world.getPlayerByUuid(gameprofile.getId());
                boolean flag1 = playerentity != null && playerentity.isWearing(PlayerModelPart.CAPE) && ("Dinnerbone".equals(gameprofile.getName()) || "Grumm".equals(gameprofile.getName()));
                this.mc.getTextureManager().bindTexture(networkplayerinfo1.getLocationSkin());
                int i3 = 8 + (flag1 ? 8 : 0);
                int j3 = 8 * (flag1 ? -1 : 1);
                AbstractGui.blit(p_238523_1_, k2, l2, 8, 8, 8.0f, i3, 8, j3, 64, 64);
                if (playerentity != null && playerentity.isWearing(PlayerModelPart.HAT)) {
                    int k3 = 8 + (flag1 ? 8 : 0);
                    int l3 = 8 * (flag1 ? -1 : 1);
                    AbstractGui.blit(p_238523_1_, k2, l2, 8, 8, 40.0f, k3, 8, l3, 64, 64);
                }
                k2 += 9;
            }
            this.mc.fontRenderer.func_243246_a(p_238523_1_, this.getDisplayName(networkplayerinfo1), k2, l2, networkplayerinfo1.getGameType() == GameType.SPECTATOR ? -1862270977 : -1);
            if (p_238523_4_ != null && networkplayerinfo1.getGameType() != GameType.SPECTATOR && (i6 = (l5 = k2 + i + 1) + l) - l5 > 5) {
                this.func_175247_a_(p_238523_4_, l2, gameprofile.getName(), l5, i6, networkplayerinfo1, p_238523_1_);
            }
            this.func_238522_a_(p_238523_1_, i1, k2 - (flag ? 9 : 0), l2, networkplayerinfo1);
        }
        if (list2 != null) {
            k1 = k1 + j4 * 9 + 1;
            PlayerTabOverlayGui.fill(p_238523_1_, p_238523_2_ / 2 - l1 / 2 - 1, k1 - 1, p_238523_2_ / 2 + l1 / 2 + 1, k1 + list2.size() * 9, Integer.MIN_VALUE);
            for (IReorderingProcessor ireorderingprocessor3 : list2) {
                int k5 = this.mc.fontRenderer.func_243245_a(ireorderingprocessor3);
                this.mc.fontRenderer.func_238407_a_(p_238523_1_, ireorderingprocessor3, p_238523_2_ / 2 - k5 / 2, k1, -1);
                k1 += 9;
            }
        }
    }

    protected void func_238522_a_(MatrixStack p_238522_1_, int p_238522_2_, int p_238522_3_, int p_238522_4_, NetworkPlayerInfo p_238522_5_) {
        RenderSystem.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.getTextureManager().bindTexture(GUI_ICONS_LOCATION);
        boolean i = false;
        int j = p_238522_5_.getResponseTime() < 0 ? 5 : (p_238522_5_.getResponseTime() < 150 ? 0 : (p_238522_5_.getResponseTime() < 300 ? 1 : (p_238522_5_.getResponseTime() < 600 ? 2 : (p_238522_5_.getResponseTime() < 1000 ? 3 : 4))));
        this.setBlitOffset(this.getBlitOffset() + 100);
        this.blit(p_238522_1_, p_238522_3_ + p_238522_2_ - 11, p_238522_4_, 0, 176 + j * 8, 10, 8);
        this.setBlitOffset(this.getBlitOffset() - 100);
    }

    private void func_175247_a_(ScoreObjective objective, int p_175247_2_, String name, int p_175247_4_, int p_175247_5_, NetworkPlayerInfo info, MatrixStack p_175247_7_) {
        int i = objective.getScoreboard().getOrCreateScore(name, objective).getScorePoints();
        if (objective.getRenderType() == ScoreCriteria.RenderType.HEARTS) {
            boolean flag;
            this.mc.getTextureManager().bindTexture(GUI_ICONS_LOCATION);
            long j = Util.milliTime();
            if (this.lastTimeOpened == info.getRenderVisibilityId()) {
                if (i < info.getLastHealth()) {
                    info.setLastHealthTime(j);
                    info.setHealthBlinkTime(this.guiIngame.getTicks() + 20);
                } else if (i > info.getLastHealth()) {
                    info.setLastHealthTime(j);
                    info.setHealthBlinkTime(this.guiIngame.getTicks() + 10);
                }
            }
            if (j - info.getLastHealthTime() > 1000L || this.lastTimeOpened != info.getRenderVisibilityId()) {
                info.setLastHealth(i);
                info.setDisplayHealth(i);
                info.setLastHealthTime(j);
            }
            info.setRenderVisibilityId(this.lastTimeOpened);
            info.setLastHealth(i);
            int k = MathHelper.ceil((float)Math.max(i, info.getDisplayHealth()) / 2.0f);
            int l = Math.max(MathHelper.ceil(i / 2), Math.max(MathHelper.ceil(info.getDisplayHealth() / 2), 10));
            boolean bl = flag = info.getHealthBlinkTime() > (long)this.guiIngame.getTicks() && (info.getHealthBlinkTime() - (long)this.guiIngame.getTicks()) / 3L % 2L == 1L;
            if (k > 0) {
                int i1 = MathHelper.floor(Math.min((float)(p_175247_5_ - p_175247_4_ - 4) / (float)l, 9.0f));
                if (i1 > 3) {
                    for (int j1 = k; j1 < l; ++j1) {
                        this.blit(p_175247_7_, p_175247_4_ + j1 * i1, p_175247_2_, flag ? 25 : 16, 0, 9, 9);
                    }
                    for (int l1 = 0; l1 < k; ++l1) {
                        this.blit(p_175247_7_, p_175247_4_ + l1 * i1, p_175247_2_, flag ? 25 : 16, 0, 9, 9);
                        if (flag) {
                            if (l1 * 2 + 1 < info.getDisplayHealth()) {
                                this.blit(p_175247_7_, p_175247_4_ + l1 * i1, p_175247_2_, 70, 0, 9, 9);
                            }
                            if (l1 * 2 + 1 == info.getDisplayHealth()) {
                                this.blit(p_175247_7_, p_175247_4_ + l1 * i1, p_175247_2_, 79, 0, 9, 9);
                            }
                        }
                        if (l1 * 2 + 1 < i) {
                            this.blit(p_175247_7_, p_175247_4_ + l1 * i1, p_175247_2_, l1 >= 10 ? 160 : 52, 0, 9, 9);
                        }
                        if (l1 * 2 + 1 != i) continue;
                        this.blit(p_175247_7_, p_175247_4_ + l1 * i1, p_175247_2_, l1 >= 10 ? 169 : 61, 0, 9, 9);
                    }
                } else {
                    float f = MathHelper.clamp((float)i / 20.0f, 0.0f, 1.0f);
                    int k1 = (int)((1.0f - f) * 255.0f) << 16 | (int)(f * 255.0f) << 8;
                    String s = "" + (float)i / 2.0f;
                    if (p_175247_5_ - this.mc.fontRenderer.getStringWidth(s + "hp") >= p_175247_4_) {
                        s = s + "hp";
                    }
                    this.mc.fontRenderer.drawStringWithShadow(p_175247_7_, s, (p_175247_5_ + p_175247_4_) / 2 - this.mc.fontRenderer.getStringWidth(s) / 2, p_175247_2_, k1);
                }
            }
        } else {
            String s1 = (Object)((Object)TextFormatting.YELLOW) + "" + i;
            this.mc.fontRenderer.drawStringWithShadow(p_175247_7_, s1, p_175247_5_ - this.mc.fontRenderer.getStringWidth(s1), p_175247_2_, 0xFFFFFF);
        }
    }

    public void setFooter(@Nullable ITextComponent footerIn) {
        this.footer = footerIn;
    }

    public void setHeader(@Nullable ITextComponent headerIn) {
        this.header = headerIn;
    }

    public void resetFooterHeader() {
        this.header = null;
        this.footer = null;
    }

    static class PlayerComparator
    implements Comparator<NetworkPlayerInfo> {
        private PlayerComparator() {
        }

        @Override
        public int compare(NetworkPlayerInfo p_compare_1_, NetworkPlayerInfo p_compare_2_) {
            ScorePlayerTeam scoreplayerteam = p_compare_1_.getPlayerTeam();
            ScorePlayerTeam scoreplayerteam1 = p_compare_2_.getPlayerTeam();
            return ComparisonChain.start().compareTrueFirst(p_compare_1_.getGameType() != GameType.SPECTATOR, p_compare_2_.getGameType() != GameType.SPECTATOR).compare((Comparable<?>)((Object)(scoreplayerteam != null ? scoreplayerteam.getName() : "")), (Comparable<?>)((Object)(scoreplayerteam1 != null ? scoreplayerteam1.getName() : ""))).compare(p_compare_1_.getGameProfile().getName(), p_compare_2_.getGameProfile().getName(), String::compareToIgnoreCase).result();
        }
    }
}

