/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class SixWayBlock
extends Block {
    private static final Direction[] FACING_VALUES = Direction.values();
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = Util.make(Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] shapes;

    protected SixWayBlock(float apothem, AbstractBlock.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(apothem);
    }

    private VoxelShape[] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.makeCuboidShape(f * 16.0f, f * 16.0f, f * 16.0f, f1 * 16.0f, f1 * 16.0f, f1 * 16.0f);
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = VoxelShapes.create(0.5 + Math.min((double)(-apothem), (double)direction.getXOffset() * 0.5), 0.5 + Math.min((double)(-apothem), (double)direction.getYOffset() * 0.5), 0.5 + Math.min((double)(-apothem), (double)direction.getZOffset() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.getXOffset() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.getYOffset() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.getZOffset() * 0.5));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = VoxelShapes.or(voxelshape1, avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    @Override
    public boolean propagatesSkylightDown(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    @Override
    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.get(FACING_TO_PROPERTY_MAP.get(FACING_VALUES[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }
}

