/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RedstoneWallTorchBlock
extends RedstoneTorchBlock {
    public static final DirectionProperty FACING = HorizontalBlock.HORIZONTAL_FACING;
    public static final BooleanProperty REDSTONE_TORCH_LIT = RedstoneTorchBlock.LIT;

    protected RedstoneWallTorchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.setDefaultState((BlockState)((BlockState)((BlockState)this.stateContainer.getBaseState()).with(FACING, Direction.NORTH)).with(REDSTONE_TORCH_LIT, true));
    }

    @Override
    public String getTranslationKey() {
        return this.asItem().getTranslationKey();
    }

    @Override
    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return WallTorchBlock.getShapeForState(state);
    }

    @Override
    public boolean isValidPosition(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Blocks.WALL_TORCH.isValidPosition(state, worldIn, pos);
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return Blocks.WALL_TORCH.updatePostPlacement(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockItemUseContext context) {
        BlockState blockstate = Blocks.WALL_TORCH.getStateForPlacement(context);
        return blockstate == null ? null : (BlockState)this.getDefaultState().with(FACING, blockstate.get(FACING));
    }

    @Override
    public void animateTick(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.get(REDSTONE_TORCH_LIT).booleanValue()) {
            Direction direction = stateIn.get(FACING).getOpposite();
            double d0 = 0.27;
            double d1 = (double)pos.getX() + 0.5 + (rand.nextDouble() - 0.5) * 0.2 + 0.27 * (double)direction.getXOffset();
            double d2 = (double)pos.getY() + 0.7 + (rand.nextDouble() - 0.5) * 0.2 + 0.22;
            double d3 = (double)pos.getZ() + 0.5 + (rand.nextDouble() - 0.5) * 0.2 + 0.27 * (double)direction.getZOffset();
            worldIn.addParticle(this.particleData, d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected boolean shouldBeOff(World worldIn, BlockPos pos, BlockState state) {
        Direction direction = state.get(FACING).getOpposite();
        return worldIn.isSidePowered(pos.offset(direction), direction);
    }

    @Override
    public int getWeakPower(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.get(REDSTONE_TORCH_LIT) != false && blockState.get(FACING) != side ? 15 : 0;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return Blocks.WALL_TORCH.rotate(state, rot);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return Blocks.WALL_TORCH.mirror(state, mirrorIn);
    }

    @Override
    protected void fillStateContainer(StateContainer.Builder<Block, BlockState> builder) {
        builder.add(FACING, REDSTONE_TORCH_LIT);
    }
}

