/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.serialization;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class DataResult<R>
implements App<Mu, R> {
    private final Either<R, PartialResult<R>> result;
    private final Lifecycle lifecycle;

    public static <R> DataResult<R> unbox(App<Mu, R> box) {
        return (DataResult)box;
    }

    public static <R> DataResult<R> success(R result) {
        return DataResult.success(result, Lifecycle.experimental());
    }

    public static <R> DataResult<R> error(String message, R partialResult) {
        return DataResult.error(message, partialResult, Lifecycle.experimental());
    }

    public static <R> DataResult<R> error(String message) {
        return DataResult.error(message, Lifecycle.experimental());
    }

    public static <R> DataResult<R> success(R result, Lifecycle experimental) {
        return new DataResult<R>(Either.left(result), experimental);
    }

    public static <R> DataResult<R> error(String message, R partialResult, Lifecycle lifecycle) {
        return new DataResult(Either.right(new PartialResult<R>(message, Optional.of(partialResult))), lifecycle);
    }

    public static <R> DataResult<R> error(String message, Lifecycle lifecycle) {
        return new DataResult(Either.right(new PartialResult(message, Optional.empty())), lifecycle);
    }

    public static <K, V> Function<K, DataResult<V>> partialGet(Function<K, V> partialGet, Supplier<String> errorPrefix) {
        return name -> Optional.ofNullable(partialGet.apply(name)).map(DataResult::success).orElseGet(() -> DataResult.lambda$null$0((Supplier)errorPrefix, name));
    }

    private static <R> DataResult<R> create(Either<R, PartialResult<R>> result, Lifecycle lifecycle) {
        return new DataResult<R>(result, lifecycle);
    }

    private DataResult(Either<R, PartialResult<R>> result, Lifecycle lifecycle) {
        this.result = result;
        this.lifecycle = lifecycle;
    }

    public Either<R, PartialResult<R>> get() {
        return this.result;
    }

    public Optional<R> result() {
        return this.result.left();
    }

    public Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public Optional<R> resultOrPartial(Consumer<String> onError) {
        return this.result.map(Optional::of, r -> {
            onError.accept(((PartialResult)r).message);
            return ((PartialResult)r).partialResult;
        });
    }

    public R getOrThrow(boolean allowPartial, Consumer<String> onError) {
        return (R)this.result.map(l -> l, r -> {
            onError.accept(((PartialResult)r).message);
            if (allowPartial && ((PartialResult)r).partialResult.isPresent()) {
                return ((PartialResult)r).partialResult.get();
            }
            throw new RuntimeException(((PartialResult)r).message);
        });
    }

    public Optional<PartialResult<R>> error() {
        return this.result.right();
    }

    public <T> DataResult<T> map(Function<? super R, ? extends T> function) {
        return DataResult.create(this.result.mapBoth(function, r -> new PartialResult(((PartialResult)r).message, ((PartialResult)r).partialResult.map(function))), this.lifecycle);
    }

    public DataResult<R> promotePartial(Consumer<String> onError) {
        return this.result.map(r -> new DataResult<Object>(Either.left(r), this.lifecycle), r -> {
            onError.accept(((PartialResult)r).message);
            return ((PartialResult)r).partialResult.map((? super T pr) -> new DataResult<Object>(Either.left(pr), this.lifecycle)).orElseGet(() -> DataResult.create(Either.right(r), this.lifecycle));
        });
    }

    private static String appendMessages(String first, String second) {
        return first + "; " + second;
    }

    public <R2> DataResult<R2> flatMap(Function<? super R, ? extends DataResult<R2>> function) {
        return this.result.map(l -> {
            DataResult second = (DataResult)function.apply((R)l);
            return DataResult.create(second.get(), this.lifecycle.add(second.lifecycle));
        }, r -> ((PartialResult)r).partialResult.map((? super T value) -> {
            DataResult second = (DataResult)function.apply((R)value);
            return DataResult.create(Either.right(second.get().map(l2 -> new PartialResult<Object>(((PartialResult)r).message, Optional.of(l2)), r2 -> new PartialResult(DataResult.appendMessages(((PartialResult)r).message, ((PartialResult)r2).message), ((PartialResult)r2).partialResult))), this.lifecycle.add(second.lifecycle));
        }).orElseGet(() -> DataResult.create(Either.right(new PartialResult(((PartialResult)r).message, Optional.empty())), this.lifecycle)));
    }

    public <R2> DataResult<R2> ap(DataResult<Function<R, R2>> functionResult) {
        return DataResult.create(this.result.map(arg -> functionResult.result.mapBoth(func -> func.apply(arg), funcError -> new PartialResult<Object>(((PartialResult)funcError).message, ((PartialResult)funcError).partialResult.map((? super T f) -> f.apply(arg)))), argError -> Either.right(functionResult.result.map(func -> new PartialResult(((PartialResult)argError).message, ((PartialResult)argError).partialResult.map(func)), funcError -> new PartialResult(DataResult.appendMessages(((PartialResult)argError).message, ((PartialResult)funcError).message), ((PartialResult)argError).partialResult.flatMap((? super T a) -> ((PartialResult)funcError).partialResult.map((? super T f) -> f.apply(a))))))), this.lifecycle.add(functionResult.lifecycle));
    }

    public <R2, S> DataResult<S> apply2(BiFunction<R, R2, S> function, DataResult<R2> second) {
        return DataResult.unbox(DataResult.instance().apply2(function, this, second));
    }

    public <R2, S> DataResult<S> apply2stable(BiFunction<R, R2, S> function, DataResult<R2> second) {
        Instance instance = DataResult.instance();
        DataResult f = DataResult.unbox(instance.point(function)).setLifecycle(Lifecycle.stable());
        return DataResult.unbox(instance.ap2(f, this, second));
    }

    public <R2, R3, S> DataResult<S> apply3(Function3<R, R2, R3, S> function, DataResult<R2> second, DataResult<R3> third) {
        return DataResult.unbox(DataResult.instance().apply3(function, this, second, third));
    }

    public DataResult<R> setPartial(Supplier<R> partial) {
        return DataResult.create(this.result.mapRight(r -> new PartialResult(((PartialResult)r).message, Optional.of(partial.get()))), this.lifecycle);
    }

    public DataResult<R> setPartial(R partial) {
        return DataResult.create(this.result.mapRight(r -> new PartialResult<Object>(((PartialResult)r).message, Optional.of(partial))), this.lifecycle);
    }

    public DataResult<R> mapError(UnaryOperator<String> function) {
        return DataResult.create(this.result.mapRight(r -> new PartialResult((String)function.apply(((PartialResult)r).message), ((PartialResult)r).partialResult)), this.lifecycle);
    }

    public DataResult<R> setLifecycle(Lifecycle lifecycle) {
        return DataResult.create(this.result, lifecycle);
    }

    public DataResult<R> addLifecycle(Lifecycle lifecycle) {
        return DataResult.create(this.result, this.lifecycle.add(lifecycle));
    }

    public static Instance instance() {
        return Instance.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataResult that = (DataResult)o;
        return Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.result);
    }

    public String toString() {
        return "DataResult[" + this.result + ']';
    }

    private static /* synthetic */ DataResult lambda$null$0(Supplier errorPrefix, Object name) {
        return DataResult.error((String)errorPrefix.get() + name);
    }

    public static enum Instance implements Applicative<com.mojang.serialization.DataResult$Mu, Mu>
    {
        INSTANCE;


        @Override
        public <T, R> App<com.mojang.serialization.DataResult$Mu, R> map(Function<? super T, ? extends R> func, App<com.mojang.serialization.DataResult$Mu, T> ts) {
            return DataResult.unbox(ts).map(func);
        }

        @Override
        public <A> App<com.mojang.serialization.DataResult$Mu, A> point(A a) {
            return DataResult.success(a);
        }

        @Override
        public <A, R> Function<App<com.mojang.serialization.DataResult$Mu, A>, App<com.mojang.serialization.DataResult$Mu, R>> lift1(App<com.mojang.serialization.DataResult$Mu, Function<A, R>> function) {
            return fa -> this.ap(function, (App)fa);
        }

        @Override
        public <A, R> App<com.mojang.serialization.DataResult$Mu, R> ap(App<com.mojang.serialization.DataResult$Mu, Function<A, R>> func, App<com.mojang.serialization.DataResult$Mu, A> arg) {
            return DataResult.unbox(arg).ap(DataResult.unbox(func));
        }

        @Override
        public <A, B, R> App<com.mojang.serialization.DataResult$Mu, R> ap2(App<com.mojang.serialization.DataResult$Mu, BiFunction<A, B, R>> func, App<com.mojang.serialization.DataResult$Mu, A> a, App<com.mojang.serialization.DataResult$Mu, B> b) {
            DataResult<BiFunction<A, B, R>> fr = DataResult.unbox(func);
            DataResult<A> ra = DataResult.unbox(a);
            DataResult<B> rb = DataResult.unbox(b);
            if (((DataResult)fr).result.left().isPresent() && ((DataResult)ra).result.left().isPresent() && ((DataResult)rb).result.left().isPresent()) {
                return new DataResult(Either.left(((BiFunction)((DataResult)fr).result.left().get()).apply(((DataResult)ra).result.left().get(), ((DataResult)rb).result.left().get())), ((DataResult)fr).lifecycle.add(((DataResult)ra).lifecycle).add(((DataResult)rb).lifecycle));
            }
            return Applicative.super.ap2(func, a, b);
        }

        @Override
        public <T1, T2, T3, R> App<com.mojang.serialization.DataResult$Mu, R> ap3(App<com.mojang.serialization.DataResult$Mu, Function3<T1, T2, T3, R>> func, App<com.mojang.serialization.DataResult$Mu, T1> t1, App<com.mojang.serialization.DataResult$Mu, T2> t2, App<com.mojang.serialization.DataResult$Mu, T3> t3) {
            DataResult<Function3<T1, T2, T3, R>> fr = DataResult.unbox(func);
            DataResult<T1> dr1 = DataResult.unbox(t1);
            DataResult<T2> dr2 = DataResult.unbox(t2);
            DataResult<T3> dr3 = DataResult.unbox(t3);
            if (((DataResult)fr).result.left().isPresent() && ((DataResult)dr1).result.left().isPresent() && ((DataResult)dr2).result.left().isPresent() && ((DataResult)dr3).result.left().isPresent()) {
                return new DataResult(Either.left(((Function3)((DataResult)fr).result.left().get()).apply(((DataResult)dr1).result.left().get(), ((DataResult)dr2).result.left().get(), ((DataResult)dr3).result.left().get())), ((DataResult)fr).lifecycle.add(((DataResult)dr1).lifecycle).add(((DataResult)dr2).lifecycle).add(((DataResult)dr3).lifecycle));
            }
            return Applicative.super.ap3(func, t1, t2, t3);
        }

        public static final class Mu
        implements Applicative.Mu {
        }
    }

    public static class PartialResult<R> {
        private final String message;
        private final Optional<R> partialResult;

        public PartialResult(String message, Optional<R> partialResult) {
            this.message = message;
            this.partialResult = partialResult;
        }

        public <R2> PartialResult<R2> map(Function<? super R, ? extends R2> function) {
            return new PartialResult<R2>(this.message, this.partialResult.map(function));
        }

        public <R2> PartialResult<R2> flatMap(Function<R, PartialResult<R2>> function) {
            if (this.partialResult.isPresent()) {
                PartialResult<R2> result = function.apply(this.partialResult.get());
                return new PartialResult<R>(DataResult.appendMessages(this.message, result.message), result.partialResult);
            }
            return new PartialResult(this.message, Optional.empty());
        }

        public String message() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartialResult that = (PartialResult)o;
            return Objects.equals(this.message, that.message) && Objects.equals(this.partialResult, that.partialResult);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.partialResult);
        }

        public String toString() {
            return "DynamicException[" + this.message + ' ' + this.partialResult + ']';
        }
    }

    public static final class Mu
    implements K1 {
    }
}

