/*
 * Decompiled with CFR 0.152.
 */
package com.minerl.multiagent.recorder;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.Malmo.Utils.JSONWorldDataHelper;
import com.minerl.multiagent.RandomHelper;
import com.minerl.multiagent.env.EnvServer;
import com.minerl.multiagent.recorder.AzureUpload;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.ReplaySender;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.server.integrated.IntegratedServer;
import nu.pattern.OpenCV;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.opengl.GL11;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.opencv.videoio.VideoWriter;

public class PlayRecorder {
    private static PlayRecorder instance = null;
    private String prefix;
    private String filename;
    private String azurePath;
    private FileWriter actionsWriter;
    private int tickCounter = -1;
    private VideoWriter videoWriter;
    private Framebuffer fbo;
    private int width;
    private int height;
    private int fps = 20;
    private boolean recording = false;
    private boolean pausedLastTick = false;
    private String userid;
    private String version;
    private Mat lastFrame;
    private byte[] lastImageBytes;
    private ByteBuffer imageByteBuffer;
    private static final int maxDuration = 6000;
    private static final int saveStatePeriod = -1;
    private String episodeid = RandomHelper.getRandomHexString();
    Minecraft mc = Minecraft.getInstance();
    JsonElement mouseState;
    JsonElement keyboardState;

    public static PlayRecorder getInstance() {
        if (instance == null) {
            instance = new PlayRecorder(Paths.get(System.getProperty("user.dir"), "recordings").toString());
        }
        return instance;
    }

    public byte[] getLastImageBytes() {
        return this.lastImageBytes;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public PlayRecorder(String prefix) {
        this.prefix = prefix;
    }

    public void start() {
        this.tickCounter = 0;
        try {
            this.width = this.mc.getFramebuffer().framebufferWidth;
            this.height = this.mc.getFramebuffer().framebufferHeight;
            if (!this.mc.gameSettings.disableRecorder) {
                this.width = 640;
                this.height = 360;
            }
            this.imageByteBuffer = ByteBuffer.allocateDirect(this.width * this.height * 3);
            this.lastImageBytes = new byte[this.imageByteBuffer.capacity()];
            this.resolveImageRequests();
            if (!this.mc.gameSettings.disableRecorder) {
                if (System.getProperty("os.name").equals("Linux")) {
                    System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
                } else {
                    OpenCV.loadLocally();
                }
                Properties versionProp = new Properties();
                versionProp.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
                this.version = versionProp.getProperty("version");
                this.userid = System.getenv().getOrDefault("MINEREC_UID", "unnamed");
                if (this.lastFrame == null) {
                    this.lastFrame = new Mat(this.height, this.width, CvType.CV_8UC3);
                }
                String playerName = this.mc.player.getName().getString();
                this.filename = Paths.get(this.prefix, this.version, playerName + "-" + this.episodeid + "-" + DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").format(LocalDateTime.now())).toString();
                this.azurePath = "";
                Files.createDirectories(Paths.get(FilenameUtils.getFullPath(this.filename), new String[0]), new FileAttribute[0]);
                this.videoWriter = new VideoWriter(this.filename + ".mp4", VideoWriter.fourcc('x', '2', '6', '4'), (double)this.fps, new Size(this.width, this.height), true);
                if (!this.videoWriter.isOpened()) {
                    System.out.println("Cannot open VideoWriter! Here's opencv build info");
                    System.out.println(Core.getBuildInformation());
                    this.videoWriter.release();
                    throw new IllegalArgumentException("VideoWriter Exception: VideoWriter not opened,check parameters.");
                }
                this.actionsWriter = new FileWriter(this.filename + ".jsonl", true);
                FileWriter optionsWriter = new FileWriter(this.filename + "-options.json", true);
                optionsWriter.write(this.getOptionsJson().toString());
                optionsWriter.close();
                IntegratedServer is = this.mc.getIntegratedServer();
                if (is != null) {
                    is.saveAndUploadWorld(this.filename + ".zip");
                    is.setUploadPath(this.azurePath);
                    is.setAutosavePeriod(-1);
                    is.setWorldZipPrefix(this.filename);
                }
            }
            if (ReplaySender.getInstance().getMode() == ReplaySender.Mode.OFF) {
                ReplaySender.getInstance().sendFromEnv();
            }
            System.out.println("Starting new video " + this.filename);
            this.recording = true;
            this.pausedLastTick = false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonObject getOptionsJson() {
        Minecraft mc = Minecraft.getInstance();
        JsonObject retVal = mc.gameSettings.optionsJson();
        retVal.addProperty("framebufferToWindowRatio", mc.getMainWindow().getFramebufferWidth() / mc.getMainWindow().getWidth());
        retVal.addProperty("windowWidth", mc.getMainWindow().getWidth());
        retVal.addProperty("windowHeight", mc.getMainWindow().getHeight());
        retVal.addProperty("framebufferWidth", mc.getMainWindow().getFramebufferWidth());
        retVal.addProperty("framebufferHeight", mc.getMainWindow().getFramebufferHeight());
        return retVal;
    }

    public void tick() {
        Minecraft mc = Minecraft.getInstance();
        ClientPlayerEntity player = mc.player;
        if (player == null || !player.isAlive()) {
            if (this.recording) {
                this.finishAndResetEpisode();
            }
            return;
        }
        if (!this.recording) {
            this.start();
        }
        if (this.pausedLastTick || mc.isGamePaused()) {
            mc.mouseHelper.setHumanInput(true);
            this.clearMouseKeyboardState();
        } else {
            mc.mouseHelper.setHumanInput(false);
            this.recordTickImpl();
        }
        this.pausedLastTick = mc.isGamePaused();
        if (this.tickCounter == 6000) {
            this.finish();
        }
    }

    private void clearMouseKeyboardState() {
        Minecraft mc = Minecraft.getInstance();
        mc.mouseHelper.clearState();
        mc.keyboardListener.clearState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTickImpl() {
        Gson gson = new Gson();
        int capacity = this.width * this.height * 3;
        this.resolveImageRequests();
        if (!this.mc.gameSettings.disableRecorder) {
            ByteBuffer imgBuffer = ByteBuffer.allocateDirect(capacity);
            this.getRGBFrame(imgBuffer);
            byte[] imgBytes = new byte[capacity];
            imgBuffer.get(imgBytes);
            this.lastFrame.put(0, 0, imgBytes);
            Core.flip(this.lastFrame, this.lastFrame, 0);
            Imgproc.cvtColor(this.lastFrame, this.lastFrame, 4);
            this.videoWriter.write(this.lastFrame);
            if (this.mc.gameSettings.envPort == 0) {
                this.mouseState = gson.toJsonTree(this.mc.mouseHelper.getState());
                this.keyboardState = gson.toJsonTree(this.mc.keyboardListener.getState());
            }
            JsonObject actions = new JsonObject();
            actions.add("mouse", this.mouseState);
            actions.add("keyboard", this.keyboardState);
            actions.addProperty("isGuiOpen", this.mc.currentScreen != null);
            actions.addProperty("isGuiInventory", this.mc.currentScreen != null && (this.mc.currentScreen instanceof InventoryScreen || this.mc.currentScreen instanceof HorseInventoryScreen));
            actions.addProperty("hotbar", this.mc.player.inventory.currentItem);
            actions.addProperty("yaw", Float.valueOf(this.mc.player.rotationYaw));
            actions.addProperty("pitch", Float.valueOf(this.mc.player.rotationPitch));
            actions.addProperty("xpos", this.mc.player.getPosX());
            actions.addProperty("ypos", this.mc.player.getPosY());
            actions.addProperty("zpos", this.mc.player.getPosZ());
            actions.addProperty("tick", this.tickCounter);
            actions.addProperty("milli", System.currentTimeMillis());
            actions.add("inventory", EnvServer.getInventoryJson());
            if (this.mc.getIntegratedServer() != null) {
                actions.addProperty("serverTick", this.mc.getIntegratedServer().getTickCounter());
                actions.addProperty("serverTickDurationMs", Float.valueOf(this.mc.getIntegratedServer().getTickTimeRaw()));
            }
            if (ReplaySender.getInstance().getMode() == ReplaySender.Mode.EXEC_CMD && this.mc.gameSettings.envPort == 0) {
                ReplaySender.getInstance().addAction(actions);
            }
            actions.add("stats", this.getStats());
            try {
                this.actionsWriter.write(actions.toString());
                this.actionsWriter.write("\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.mouseState = null;
        this.keyboardState = null;
        ++this.tickCounter;
        PlayRecorder playRecorder = this;
        synchronized (playRecorder) {
            this.notifyAll();
        }
    }

    private JsonObject getStats() {
        ClientPlayerEntity player = Minecraft.getInstance().player;
        JsonObject infoJson = new JsonObject();
        if (player != null) {
            JSONWorldDataHelper.buildAllStats(infoJson, player);
        }
        return infoJson;
    }

    private void upload() {
        AzureUpload.uploadAsync(this.filename + ".jsonl", this.azurePath);
        AzureUpload.uploadAsync(this.filename + "-options.json", this.azurePath);
        AzureUpload.uploadAsync(this.filename + ".mp4", this.azurePath);
    }

    public void finish() {
        this.tickCounter = -1;
        if (!this.recording) {
            return;
        }
        try {
            this.recording = false;
            this.mc.mouseHelper.setHumanInput(true);
            if (!Minecraft.getInstance().gameSettings.disableRecorder) {
                System.out.println("Finalizing the video");
                this.actionsWriter.close();
                this.videoWriter.write(this.lastFrame);
                this.videoWriter.release();
                this.upload();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishAndResetEpisode() {
        this.finish();
        this.lastFrame = null;
        this.episodeid = RandomHelper.getRandomHexString();
    }

    private void getRGBFrame(ByteBuffer buffer) {
        RenderSystem.pushMatrix();
        this.mc.getFramebuffer().framebufferRender(this.width, this.height);
        RenderSystem.popMatrix();
        GL11.glReadPixels(0, 0, this.width, this.height, 6407, 5121, buffer);
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void setMouseKeyboardState(MouseHelper.State mouseState, KeyboardListener.State keyboardState) {
        Gson gson = new Gson();
        this.mouseState = gson.toJsonTree(mouseState);
        this.keyboardState = gson.toJsonTree(keyboardState);
    }

    private void resolveImageRequests() {
        this.mc.getProfiler().startSection("resolveImageRequests");
        this.mc.getProfiler().endStartSection("getRBGFrame");
        this.imageByteBuffer.rewind();
        this.getRGBFrame(this.imageByteBuffer);
        this.mc.getProfiler().endStartSection("getBytes");
        this.imageByteBuffer.get(this.lastImageBytes);
        this.mc.getProfiler().endSection();
        this.mc.getProfiler().endSection();
    }
}

