/*
 * Decompiled with CFR 0.152.
 */
package com.minerl.multiagent.recorder;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class AzureUpload {
    private static final int maxRetries = 3;
    private static ExecutorService executor = Executors.newFixedThreadPool(10);

    public static boolean upload(String localPath, String azurePath) {
        String azureSas = System.getenv("AZURE_SAS");
        if (azureSas == null) {
            System.out.println("No shared access signature (SAS) found, skipping upload of " + localPath);
            return false;
        }
        String azureFullPath = azurePath + new File(localPath).getName();
        CloudBlockBlob bcc = AzureUpload.getBlobContainerClient(azureSas, azureFullPath);
        int attempt = 0;
        while (true) {
            try {
                System.out.println("uploading " + localPath);
                bcc.uploadFromFile(localPath);
                System.out.println(localPath + " -> " + azureFullPath + " upload successful!");
                return true;
            }
            catch (Exception e) {
                if (attempt == 3) {
                    throw new RuntimeException(e);
                }
                System.out.println(localPath + " -> " + azureFullPath + " upload failed with " + e.toString() + ", sleeping and retrying (attempt " + attempt + " out of " + 3 + ")");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    System.out.println("Upload thread sleep interrupted!");
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public static Future<String> uploadAsync(String localPath, String azurePath) {
        return executor.submit(() -> {
            AzureUpload.upload(localPath, azurePath);
            return azurePath;
        });
    }

    public static void finish() {
        try {
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static CloudBlockBlob getBlobContainerClient(String sas, String path) {
        String connectStr = AzureUpload.buildConnectionString(sas, path);
        try {
            CloudStorageAccount storageAccount = CloudStorageAccount.parse(connectStr);
            CloudBlobClient blobClient = storageAccount.createCloudBlobClient();
            CloudBlobContainer container = blobClient.getContainerReference(AzureUpload.getContainerFromPath(path));
            return container.getBlockBlobReference(AzureUpload.getBlobFromPath(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildConnectionString(String sas, String azurePath) {
        String storageAcc = AzureUpload.getStorageAccFromPath(azurePath);
        return String.format("BlobEndpoint=https://%s.blob.core.windows.net;SharedAccessSignature=%s", storageAcc, sas);
    }

    private static String getBlobFromPath(String azurePath) {
        AzureUpload.testAzurePath(azurePath);
        return Arrays.stream(azurePath.split("/")).skip(4L).collect(Collectors.joining("/"));
    }

    private static void testAzurePath(String azurePath) {
        if (!azurePath.startsWith("az://")) {
            throw new RuntimeException("Azure path must start with az://");
        }
    }

    private static String getContainerFromPath(String azurePath) {
        AzureUpload.testAzurePath(azurePath);
        return Arrays.stream(azurePath.split("/")).skip(3L).limit(1L).collect(Collectors.joining("/"));
    }

    private static String getStorageAccFromPath(String azurePath) {
        AzureUpload.testAzurePath(azurePath);
        return Arrays.stream(azurePath.split("/")).skip(2L).limit(1L).collect(Collectors.joining("/"));
    }

    public static ExecutorService getExecutor() {
        return executor;
    }
}

