/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class JSONWorldDataHelper {
    public static void buildAllStats(JsonObject json, ClientPlayerEntity player) {
        JSONWorldDataHelper.buildBaseMinecraftStats(json, player);
        JSONWorldDataHelper.buildLifeStats(json, player);
        JSONWorldDataHelper.buildPositionStats(json, player);
        JSONWorldDataHelper.buildBiomeStats(json, player);
        JSONWorldDataHelper.buildWeatherStats(json, player);
    }

    public static void buildBaseMinecraftStats(JsonObject json, ClientPlayerEntity player) {
        if (Minecraft.getInstance().getConnection() == null) {
            return;
        }
        Minecraft.getInstance().getConnection().sendPacket(new CClientStatusPacket(CClientStatusPacket.State.REQUEST_STATS));
        StatisticsManager statisticsManager = player.getStats();
        for (Stat stat : statisticsManager.getKeys()) {
            String statTypeName = stat.getName().split(":")[0].substring("minecraft.".length());
            String statName = stat.getName().split(":")[1].substring("minecraft.".length());
            if (!json.has(statTypeName)) {
                json.add(statTypeName, new JsonObject());
            }
            json.getAsJsonObject(statTypeName).addProperty(statName, statisticsManager.getValue(stat));
        }
    }

    public static void oldBuildBaseMinecraftStats(JsonObject json, ClientPlayerEntity player) {
        Minecraft.getInstance().getConnection().sendPacket(new CClientStatusPacket(CClientStatusPacket.State.REQUEST_STATS));
        StatisticsManager statisticsManager = player.getStats();
        for (Stat stat : statisticsManager.getKeys()) {
            Object[] stat_fields = stat.getName().split("\\.");
            JsonObject head = json;
            for (String string : stat_fields) {
                JsonObject newRoot;
                if (string.equals("minecraft")) continue;
                String token = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, string);
                if (token.endsWith(":minecraft")) {
                    token = token.replace(":minecraft", "");
                }
                if (string.equals(stat_fields[stat_fields.length - 1])) {
                    if (token.equals("drop")) {
                        token = "items_dropped";
                    }
                    head.addProperty(token, statisticsManager.getValue(stat));
                    continue;
                }
                if (head.has(token)) {
                    if (head.get(token) instanceof JsonObject) {
                        head = head.getAsJsonObject(token);
                        continue;
                    }
                    System.out.println("Duplicate token! " + Arrays.toString(stat_fields));
                    head.remove(token);
                    newRoot = new JsonObject();
                    head.add(token, newRoot);
                    head = newRoot;
                    continue;
                }
                newRoot = new JsonObject();
                head.add(token, newRoot);
                head = newRoot;
            }
        }
    }

    public static void buildLifeStats(JsonObject json, ClientPlayerEntity player) {
        JsonObject lifeStats = new JsonObject();
        lifeStats.addProperty("life", Float.valueOf(player.getHealth()));
        lifeStats.addProperty("score", player.getScore());
        lifeStats.addProperty("food", player.getFoodStats().getFoodLevel());
        lifeStats.addProperty("saturation", Float.valueOf(player.getFoodStats().getSaturationLevel()));
        lifeStats.addProperty("xp", player.experienceTotal);
        lifeStats.addProperty("is_alive", player.isAlive());
        lifeStats.addProperty("air", player.getAir());
        lifeStats.addProperty("name", player.getName().toString());
        json.add("life_stats", lifeStats);
    }

    public static void buildPositionStats(JsonObject json, ClientPlayerEntity player) {
        json.addProperty("xpos", player.getPosX());
        json.addProperty("ypos", player.getPosY());
        json.addProperty("zpos", player.getPosZ());
        json.addProperty("pitch", Float.valueOf(player.rotationPitch));
        json.addProperty("yaw", Float.valueOf(player.rotationYaw));
    }

    public static void buildBiomeStats(JsonObject json, ClientPlayerEntity player) {
        BlockPos playerPos = player.getPosition();
        Biome playerBiome = player.world.getBiome(playerPos);
        json.addProperty("biome_name", playerBiome.toString());
        json.addProperty("biome_temperature", Float.valueOf(playerBiome.getTemperature()));
        json.addProperty("biome_downfall", Float.valueOf(playerBiome.getDownfall()));
        json.addProperty("sea_level", player.world.getSeaLevel());
    }

    public static void buildWeatherStats(JsonObject json, ClientPlayerEntity player) {
        BlockPos playerPos = player.getPosition();
        json.addProperty("light_level", player.world.getLight(playerPos));
        json.addProperty("is_raining", player.world.isRaining());
        json.addProperty("can_see_sky", player.world.canSeeSky(playerPos));
    }

    public static class GridDimensions {
        public int xMin;
        public int xMax;
        public int yMin;
        public int yMax;
        public int zMin;
        public int zMax;
        public boolean absoluteCoords;
        public boolean projectDown;

        public GridDimensions() {
            this.xMin = -1;
            this.xMax = 1;
            this.zMin = -1;
            this.zMax = 1;
            this.yMin = -1;
            this.yMax = 2;
            this.absoluteCoords = false;
            this.projectDown = false;
        }

        public GridDimensions(int xMargin, int yMargin, int zMargin) {
            this.xMin = -xMargin;
            this.xMax = xMargin;
            this.yMin = -yMargin;
            this.yMax = yMargin + 1;
            this.zMin = -zMargin;
            this.zMax = zMargin;
            this.absoluteCoords = false;
            this.projectDown = false;
        }

        public GridDimensions(int xMargin, int zMargin) {
            this.xMin = -xMargin;
            this.xMax = xMargin;
            this.yMin = -1;
            this.yMax = -1;
            this.zMin = -zMargin;
            this.zMax = zMargin;
            this.absoluteCoords = false;
            this.projectDown = false;
        }
    }
}

