/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.Malmo.Utils;

import com.google.common.base.CaseFormat;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;

public class CraftingHelper {
    private static Map<ClientPlayerEntity, Integer> fuelCaches = new HashMap<ClientPlayerEntity, Integer>();

    public static void reset() {
        fuelCaches = new HashMap<ClientPlayerEntity, Integer>();
    }

    public static NonNullList<ItemStack> consolidateItemStacks(NonNullList<ItemStack> inputStacks) {
        NonNullList<ItemStack> outputStacks = NonNullList.create();
        for (ItemStack sourceIS : inputStacks) {
            boolean bFound = false;
            for (ItemStack destIS : outputStacks) {
                if (destIS == null || sourceIS == null || !CraftingHelper.itemStackIngredientsMatch(destIS, sourceIS)) continue;
                bFound = true;
                destIS.setCount(destIS.getCount() + sourceIS.getCount());
            }
            if (bFound) continue;
            assert (sourceIS != null);
            outputStacks.add(sourceIS.copy());
        }
        return outputStacks;
    }

    public static boolean playerHasIngredients(ClientPlayerEntity player, List<ItemStack> ingredients) {
        NonNullList<ItemStack> main = player.inventory.mainInventory;
        NonNullList<ItemStack> arm = player.inventory.armorInventory;
        for (ItemStack isIngredient : ingredients) {
            int target = isIngredient.getCount();
            for (int i = 0; i < main.size() + arm.size() && target > 0; ++i) {
                ItemStack isPlayer;
                ItemStack itemStack = isPlayer = i >= main.size() ? arm.get(i - main.size()) : main.get(i);
                if (isPlayer == null || isIngredient == null || !CraftingHelper.itemStackIngredientsMatch(isPlayer, isIngredient)) continue;
                target -= isPlayer.getCount();
            }
            if (target <= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean itemStackIngredientsMatch(ItemStack A, ItemStack B2) {
        if (A == null && B2 == null) {
            return true;
        }
        if (A == null || B2 == null) {
            return false;
        }
        return ItemStack.areItemsEqual(A, B2);
    }

    public static int totalBurnTimeInInventory(ClientPlayerEntity player) {
        Integer fromCache = fuelCaches.get(player);
        int total = fromCache != null ? fromCache : 0;
        for (int i = 0; i < player.inventory.mainInventory.size(); ++i) {
            ItemStack is = player.inventory.mainInventory.get(i);
            total += is.getCount() * FurnaceTileEntity.getBurnTimes().get(is);
        }
        return total;
    }

    public static void removeIngredientsFromPlayer(ClientPlayerEntity player, List<ItemStack> ingredients) {
        NonNullList<ItemStack> main = player.inventory.mainInventory;
        NonNullList<ItemStack> arm = player.inventory.armorInventory;
        for (ItemStack isIngredient : ingredients) {
            int target = isIngredient.getCount();
            for (int i = 0; i < main.size() + arm.size() && target > 0; ++i) {
                ItemStack isPlayer;
                ItemStack itemStack = isPlayer = i >= main.size() ? arm.get(i - main.size()) : main.get(i);
                if (!CraftingHelper.itemStackIngredientsMatch(isPlayer, isIngredient)) continue;
                if (target >= isPlayer.getCount()) {
                    target -= isPlayer.getCount();
                    if (i >= main.size()) {
                        arm.get(i - main.size()).setCount(0);
                        continue;
                    }
                    main.get(i).setCount(0);
                    continue;
                }
                isPlayer.setCount(isPlayer.getCount() - target);
                target = 0;
            }
            ItemStack itemStack = isIngredient.copy();
        }
    }

    private static JsonObject listIngredients(NonNullList<ItemStack> ingredients) {
        JsonObject jsonObject = new JsonObject();
        for (ItemStack ingredient : ingredients) {
            if (ingredient.isEmpty() || ingredient.getItem().getName() == null) continue;
            jsonObject.addProperty(ingredient.getItem().getName().toString(), ingredient.getCount());
        }
        return jsonObject;
    }

    public static JsonArray generateItemJson() {
        JsonArray items = new JsonArray();
        for (Map.Entry entry : Registry.ITEM.getEntries()) {
            Item item = (Item)entry.getValue();
            if (item == null || item.getName() == null) continue;
            JsonObject json = new JsonObject();
            json.addProperty("type", item.toString());
            json.addProperty("damageable", item.isDamageable());
            ItemStack is = item.getDefaultInstance();
            json.addProperty("stackable", is.isStackable());
            json.addProperty("stackSize", is.getMaxStackSize());
            json.addProperty("useAction", item.getUseAction(is).toString());
            json.addProperty("enchantable", item.isEnchantable(is));
            json.addProperty("rarity", is.getRarity().toString());
            json.addProperty("maxDamage", is.getMaxDamage());
            json.addProperty("maxUseDuration", item.getUseDuration(is));
            json.addProperty("block", item instanceof BlockItem);
            json.addProperty("hasContainerItem", item.hasContainerItem());
            json.addProperty("bestEquipmentSlot", MobEntity.getSlotForItemStack(is).getName());
            if (item instanceof BlockItem) {
                BlockItem ib = (BlockItem)item;
                Block b = ib.getBlock();
                BlockState bs = b.getDefaultState();
                json.addProperty("slipperiness", Float.valueOf(b.getSlipperiness()));
                json.addProperty("hardness", Float.valueOf(bs.getBlockHardness(null, null)));
                json.addProperty("canProvidePower", bs.canProvidePower());
                json.addProperty("transparent", bs.isTransparent());
                Material mat = bs.getMaterial();
                json.addProperty("canBurn", mat.isFlammable());
                json.addProperty("isLiquid", mat.isLiquid());
                json.addProperty("blocksMovement", mat.blocksMovement());
                json.addProperty("isReplaceable", mat.isReplaceable());
                json.addProperty("woodenMaterial", mat == Material.WOOD);
                json.addProperty("ironMaterial", mat == Material.IRON);
                json.addProperty("glassyMaterial", mat == Material.GLASS);
                boolean hasDirection = false;
                boolean hasColour = false;
                boolean hasVariant = false;
                for (Property prop : bs.getProperties()) {
                    System.out.println(item.getName().toString() + " -- " + prop);
                    if (prop instanceof DirectionProperty) {
                        hasDirection = true;
                    }
                    if (prop instanceof EnumProperty && prop.getName().equals("color")) {
                        hasColour = true;
                    }
                    if (!(prop instanceof EnumProperty) || !prop.getName().equals("variant")) continue;
                    hasVariant = true;
                    json.addProperty("variant", bs.get(prop).toString());
                }
                json.addProperty("hasDirection", hasDirection);
                json.addProperty("hasColour", hasColour);
                json.addProperty("hasVariant", hasVariant);
            }
            items.add(json);
        }
        return items;
    }

    public static JsonArray generateStats() {
        JsonArray stats = new JsonArray();
        for (Map.Entry<RegistryKey<StatType<?>>, StatType<?>> entry : Registry.STATS.getEntries()) {
            String statType = entry.getKey().getLocation().getPath();
            if (statType.equals("custom")) {
                entry.getValue().forEach(stat -> stats.add(CraftingHelper.statToJson(stat.getName())));
                continue;
            }
            if (statType.equals(Stats.BLOCK_MINED.getTranslationKey())) {
                for (Block block : Registry.BLOCK) {
                    stats.add(CraftingHelper.statToJson(statType + "." + block.toString()));
                }
                continue;
            }
            for (Item item : Registry.ITEM) {
                stats.add(CraftingHelper.statToJson(statType + "." + item.toString()));
            }
        }
        return stats;
    }

    private static JsonObject statToJson(String statId) {
        JsonObject json = new JsonObject();
        json.addProperty("statID", statId);
        JsonArray tokens = new JsonArray();
        for (String token : statId.split("\\.")) {
            if (token.contains("minecraft")) continue;
            tokens.add(new JsonPrimitive(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, token)));
        }
        json.add("minerl_keys", tokens);
        return json;
    }

    public static JsonArray generateCraftingRecipeJson() {
        JsonArray craftingRecipes = new JsonArray();
        Minecraft mc = Minecraft.getInstance();
        for (IRecipe<?> recipe : mc.world.getRecipeManager().getRecipes()) {
            if (recipe == null || recipe.getRecipeOutput().getItem().getName().toString() == null) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("outputItemName", recipe.getRecipeOutput().getItem().getName().toString());
            jsonObject.addProperty("outputCount", recipe.getRecipeOutput().getCount());
            jsonObject.addProperty("recipeSize", CraftingHelper.getRecipeSize(recipe));
            jsonObject.addProperty("type", recipe.getClass().getSimpleName());
            jsonObject.add("ingredients", CraftingHelper.listIngredients(recipe.getIngredients()));
            craftingRecipes.add(jsonObject);
        }
        return craftingRecipes;
    }

    private static int getRecipeSize(IRecipe recipe) {
        if (recipe.canFit(1, 1)) {
            return 1;
        }
        if (recipe.canFit(2, 2)) {
            return 4;
        }
        return 9;
    }

    public static void dumpItemProperties(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream("..//..//build//install//Python_Examples//item_database.json");
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
        BufferedWriter writer = new BufferedWriter(osw);
        JsonArray itemTypes = CraftingHelper.generateItemJson();
        writer.write(itemTypes.toString());
        writer.close();
    }

    public static void dumpMinecraftObjectRules(String filename) {
        JsonObject allRecipes = new JsonObject();
        allRecipes.addProperty("docstring", "THIS IS AN AUTO GENERATED FILE! This file was generated by com.microsoft.Malmo.Utils.CraftingHelper.dumpMinecraftObjectRules()");
        allRecipes.add("items", CraftingHelper.generateItemJson());
        allRecipes.add("stats", CraftingHelper.generateStats());
        try {
            FileWriter writer = new FileWriter(filename);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)allRecipes, (Appendable)writer);
            System.out.println("Wrote json to " + System.getProperty("user.dir") + filename);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CraftingHelper.dumpMinecraftObjectRules("../herobraine/hero/mc_constants.1.16.json");
    }
}

